package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaChannelStatusBuilder extends KafkaChannelStatusFluentImpl<KafkaChannelStatusBuilder> implements VisitableBuilder<KafkaChannelStatus,KafkaChannelStatusBuilder> {

    KafkaChannelStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaChannelStatusBuilder() { 
        this(true);
    }


    public KafkaChannelStatusBuilder(Boolean validationEnabled) { 
        this(new KafkaChannelStatus(), validationEnabled);
    }


    public KafkaChannelStatusBuilder(KafkaChannelStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public KafkaChannelStatusBuilder(KafkaChannelStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new KafkaChannelStatus(), validationEnabled);
    }


    public KafkaChannelStatusBuilder(KafkaChannelStatusFluent<?> fluent,KafkaChannelStatus instance) { 
        this(fluent, instance, true);
    }


    public KafkaChannelStatusBuilder(KafkaChannelStatusFluent<?> fluent,KafkaChannelStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAddress(instance.getAddress()); 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withDeadLetterChannel(instance.getDeadLetterChannel()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSubscribers(instance.getSubscribers()); 
        this.validationEnabled = validationEnabled; 
    }


    public KafkaChannelStatusBuilder(KafkaChannelStatus instance) { 
        this(instance,true);
    }


    public KafkaChannelStatusBuilder(KafkaChannelStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAddress(instance.getAddress()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withDeadLetterChannel(instance.getDeadLetterChannel()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSubscribers(instance.getSubscribers()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.EditableKafkaChannelStatus build() {
        EditableKafkaChannelStatus buildable = new EditableKafkaChannelStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getConditions(),fluent.getDeadLetterChannel(),fluent.getObservedGeneration(),fluent.getSubscribers());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaChannelStatusBuilder that = (KafkaChannelStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
