package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIVersionKindBuilder extends APIVersionKindFluentImpl<APIVersionKindBuilder> implements VisitableBuilder<APIVersionKind,APIVersionKindBuilder> {

    APIVersionKindFluent<?> fluent;
    Boolean validationEnabled;

    public APIVersionKindBuilder() { 
        this(true);
    }


    public APIVersionKindBuilder(Boolean validationEnabled) { 
        this(new APIVersionKind(), validationEnabled);
    }


    public APIVersionKindBuilder(APIVersionKindFluent<?> fluent) { 
        this(fluent, true);
    }


    public APIVersionKindBuilder(APIVersionKindFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new APIVersionKind(), validationEnabled);
    }


    public APIVersionKindBuilder(APIVersionKindFluent<?> fluent,APIVersionKind instance) { 
        this(fluent, instance, true);
    }


    public APIVersionKindBuilder(APIVersionKindFluent<?> fluent,APIVersionKind instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }


    public APIVersionKindBuilder(APIVersionKind instance) { 
        this(instance,true);
    }


    public APIVersionKindBuilder(APIVersionKind instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.sources.v1beta1.EditableAPIVersionKind build() {
        EditableAPIVersionKind buildable = new EditableAPIVersionKind(fluent.getApiVersion(),fluent.getKind());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIVersionKindBuilder that = (APIVersionKindBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
