package io.fabric8.knative.sources.v1beta1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

public class ApiServerSourceSpecFluentImpl<A extends ApiServerSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ApiServerSourceSpecFluent<A> {

    private CloudEventOverridesBuilder ceOverrides;
    private String mode;
    private APIVersionKindBuilder owner;
    private List<APIVersionKindSelectorBuilder> resources;
    private String serviceAccountName;
    private DestinationBuilder sink;

    public ApiServerSourceSpecFluentImpl() { 
    }


    public ApiServerSourceSpecFluentImpl(ApiServerSourceSpec instance) { 
        this.withCeOverrides(instance.getCeOverrides()); 
        this.withMode(instance.getMode()); 
        this.withOwner(instance.getOwner()); 
        this.withResources(instance.getResources()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSink(instance.getSink()); 
    }


    
/**
 * This method has been deprecated, please use method buildCeOverrides instead.
 * @return The buildable object.
 */
@Deprecated public CloudEventOverrides getCeOverrides() {
        return this.ceOverrides!=null?this.ceOverrides.build():null;
    }

    public CloudEventOverrides buildCeOverrides() {
        return this.ceOverrides!=null?this.ceOverrides.build():null;
    }

    public A withCeOverrides(CloudEventOverrides ceOverrides) {
        _visitables.get("ceOverrides").remove(this.ceOverrides);
        if (ceOverrides!=null){ this.ceOverrides= new CloudEventOverridesBuilder(ceOverrides); _visitables.get("ceOverrides").add(this.ceOverrides);} return (A) this;
    }

    public Boolean hasCeOverrides() {
        return this.ceOverrides != null;
    }

    public ApiServerSourceSpecFluent.CeOverridesNested<A> withNewCeOverrides() {
        return new CeOverridesNestedImpl();
    }

    public ApiServerSourceSpecFluent.CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
        return new CeOverridesNestedImpl(item);
    }

    public ApiServerSourceSpecFluent.CeOverridesNested<A> editCeOverrides() {
        return withNewCeOverridesLike(getCeOverrides());
    }

    public ApiServerSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverrides() {
        return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): new CloudEventOverridesBuilder().build());
    }

    public ApiServerSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
        return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): item);
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode=mode; return (A) this;
    }

    public Boolean hasMode() {
        return this.mode != null;
    }

    public A withNewMode(String arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuilder arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuffer arg1) {
        return (A)withMode(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildOwner instead.
 * @return The buildable object.
 */
@Deprecated public APIVersionKind getOwner() {
        return this.owner!=null?this.owner.build():null;
    }

    public APIVersionKind buildOwner() {
        return this.owner!=null?this.owner.build():null;
    }

    public A withOwner(APIVersionKind owner) {
        _visitables.get("owner").remove(this.owner);
        if (owner!=null){ this.owner= new APIVersionKindBuilder(owner); _visitables.get("owner").add(this.owner);} return (A) this;
    }

    public Boolean hasOwner() {
        return this.owner != null;
    }

    public A withNewOwner(String apiVersion,String kind) {
        return (A)withOwner(new APIVersionKind(apiVersion, kind));
    }

    public ApiServerSourceSpecFluent.OwnerNested<A> withNewOwner() {
        return new OwnerNestedImpl();
    }

    public ApiServerSourceSpecFluent.OwnerNested<A> withNewOwnerLike(APIVersionKind item) {
        return new OwnerNestedImpl(item);
    }

    public ApiServerSourceSpecFluent.OwnerNested<A> editOwner() {
        return withNewOwnerLike(getOwner());
    }

    public ApiServerSourceSpecFluent.OwnerNested<A> editOrNewOwner() {
        return withNewOwnerLike(getOwner() != null ? getOwner(): new APIVersionKindBuilder().build());
    }

    public ApiServerSourceSpecFluent.OwnerNested<A> editOrNewOwnerLike(APIVersionKind item) {
        return withNewOwnerLike(getOwner() != null ? getOwner(): item);
    }

    public A addToResources(int index,APIVersionKindSelector item) {
        if (this.resources == null) {this.resources = new ArrayList<APIVersionKindSelectorBuilder>();}
        APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
    }

    public A setToResources(int index,APIVersionKindSelector item) {
        if (this.resources == null) {this.resources = new ArrayList<APIVersionKindSelectorBuilder>();}
        APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);
        if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
        if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
         return (A)this;
    }

    public A addToResources(APIVersionKindSelector... items) {
        if (this.resources == null) {this.resources = new ArrayList<APIVersionKindSelectorBuilder>();}
        for (APIVersionKindSelector item : items) {APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A addAllToResources(Collection<APIVersionKindSelector> items) {
        if (this.resources == null) {this.resources = new ArrayList<APIVersionKindSelectorBuilder>();}
        for (APIVersionKindSelector item : items) {APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A removeFromResources(APIVersionKindSelector... items) {
        for (APIVersionKindSelector item : items) {APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeAllFromResources(Collection<APIVersionKindSelector> items) {
        for (APIVersionKindSelector item : items) {APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromResources(Predicate<APIVersionKindSelectorBuilder> predicate) {
        if (resources == null) return (A) this;
        final Iterator<APIVersionKindSelectorBuilder> each = resources.iterator();
        final List visitables = _visitables.get("resources");
        while (each.hasNext()) {
          APIVersionKindSelectorBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<APIVersionKindSelector> getResources() {
        return build(resources);
    }

    public List<APIVersionKindSelector> buildResources() {
        return build(resources);
    }

    public APIVersionKindSelector buildResource(int index) {
        return this.resources.get(index).build();
    }

    public APIVersionKindSelector buildFirstResource() {
        return this.resources.get(0).build();
    }

    public APIVersionKindSelector buildLastResource() {
        return this.resources.get(resources.size() - 1).build();
    }

    public APIVersionKindSelector buildMatchingResource(Predicate<APIVersionKindSelectorBuilder> predicate) {
        for (APIVersionKindSelectorBuilder item: resources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingResource(Predicate<APIVersionKindSelectorBuilder> predicate) {
        for (APIVersionKindSelectorBuilder item: resources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withResources(List<APIVersionKindSelector> resources) {
        if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
        if (resources != null) {this.resources = new ArrayList<APIVersionKindSelectorBuilder>(); for (APIVersionKindSelector item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
    }

    public A withResources(APIVersionKindSelector... resources) {
        if (this.resources != null) {this.resources.clear();}
        if (resources != null) {for (APIVersionKindSelector item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources() {
        return resources != null && !resources.isEmpty();
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> addNewResource() {
        return new ResourcesNestedImpl();
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> addNewResourceLike(APIVersionKindSelector item) {
        return new ResourcesNestedImpl(-1, item);
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> setNewResourceLike(int index,APIVersionKindSelector item) {
        return new ResourcesNestedImpl(index, item);
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> editResource(int index) {
        if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
        return setNewResourceLike(index, buildResource(index));
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> editFirstResource() {
        if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
        return setNewResourceLike(0, buildResource(0));
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> editLastResource() {
        int index = resources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
        return setNewResourceLike(index, buildResource(index));
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> editMatchingResource(Predicate<APIVersionKindSelectorBuilder> predicate) {
        int index = -1;
        for (int i=0;i<resources.size();i++) { 
        if (predicate.test(resources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
        return setNewResourceLike(index, buildResource(index));
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@Deprecated public Destination getSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public Destination buildSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public A withSink(Destination sink) {
        _visitables.get("sink").remove(this.sink);
        if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} return (A) this;
    }

    public Boolean hasSink() {
        return this.sink != null;
    }

    public ApiServerSourceSpecFluent.SinkNested<A> withNewSink() {
        return new SinkNestedImpl();
    }

    public ApiServerSourceSpecFluent.SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNestedImpl(item);
    }

    public ApiServerSourceSpecFluent.SinkNested<A> editSink() {
        return withNewSinkLike(getSink());
    }

    public ApiServerSourceSpecFluent.SinkNested<A> editOrNewSink() {
        return withNewSinkLike(getSink() != null ? getSink(): new DestinationBuilder().build());
    }

    public ApiServerSourceSpecFluent.SinkNested<A> editOrNewSinkLike(Destination item) {
        return withNewSinkLike(getSink() != null ? getSink(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ApiServerSourceSpecFluentImpl that = (ApiServerSourceSpecFluentImpl) o;
        if (ceOverrides != null ? !ceOverrides.equals(that.ceOverrides) :that.ceOverrides != null) return false;
        if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
        if (owner != null ? !owner.equals(that.owner) :that.owner != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ceOverrides,  mode,  owner,  resources,  serviceAccountName,  sink,  super.hashCode());
    }

    public class CeOverridesNestedImpl<N> extends CloudEventOverridesFluentImpl<ApiServerSourceSpecFluent.CeOverridesNested<N>> implements ApiServerSourceSpecFluent.CeOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CloudEventOverridesBuilder builder;

        CeOverridesNestedImpl(CloudEventOverrides item) {
            this.builder = new CloudEventOverridesBuilder(this, item);
        }

        CeOverridesNestedImpl() {
            this.builder = new CloudEventOverridesBuilder(this);
        }

        public N and() {
             return (N) ApiServerSourceSpecFluentImpl.this.withCeOverrides(builder.build());
        }

        public N endCeOverrides() {
             return and();
        }
    }


    public class OwnerNestedImpl<N> extends APIVersionKindFluentImpl<ApiServerSourceSpecFluent.OwnerNested<N>> implements ApiServerSourceSpecFluent.OwnerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIVersionKindBuilder builder;

        OwnerNestedImpl(APIVersionKind item) {
            this.builder = new APIVersionKindBuilder(this, item);
        }

        OwnerNestedImpl() {
            this.builder = new APIVersionKindBuilder(this);
        }

        public N and() {
             return (N) ApiServerSourceSpecFluentImpl.this.withOwner(builder.build());
        }

        public N endOwner() {
             return and();
        }
    }


    public class ResourcesNestedImpl<N> extends APIVersionKindSelectorFluentImpl<ApiServerSourceSpecFluent.ResourcesNested<N>> implements ApiServerSourceSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIVersionKindSelectorBuilder builder;
        private final int index;

        ResourcesNestedImpl(int index,APIVersionKindSelector item) {
            this.index = index;
            this.builder = new APIVersionKindSelectorBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.index = -1;
            this.builder = new APIVersionKindSelectorBuilder(this);
        }

        public N and() {
             return (N) ApiServerSourceSpecFluentImpl.this.setToResources(index,builder.build());
        }

        public N endResource() {
             return and();
        }
    }


    public class SinkNestedImpl<N> extends DestinationFluentImpl<ApiServerSourceSpecFluent.SinkNested<N>> implements ApiServerSourceSpecFluent.SinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DestinationBuilder builder;

        SinkNestedImpl(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        SinkNestedImpl() {
            this.builder = new DestinationBuilder(this);
        }

        public N and() {
             return (N) ApiServerSourceSpecFluentImpl.this.withSink(builder.build());
        }

        public N endSink() {
             return and();
        }
    }


}
