package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBindingSpecBuilder extends KafkaBindingSpecFluentImpl<KafkaBindingSpecBuilder> implements VisitableBuilder<KafkaBindingSpec,KafkaBindingSpecBuilder> {

    KafkaBindingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBindingSpecBuilder() { 
        this(true);
    }


    public KafkaBindingSpecBuilder(Boolean validationEnabled) { 
        this(new KafkaBindingSpec(), validationEnabled);
    }


    public KafkaBindingSpecBuilder(KafkaBindingSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public KafkaBindingSpecBuilder(KafkaBindingSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new KafkaBindingSpec(), validationEnabled);
    }


    public KafkaBindingSpecBuilder(KafkaBindingSpecFluent<?> fluent,KafkaBindingSpec instance) { 
        this(fluent, instance, true);
    }


    public KafkaBindingSpecBuilder(KafkaBindingSpecFluent<?> fluent,KafkaBindingSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withBootstrapServers(instance.getBootstrapServers()); 
        fluent.withNet(instance.getNet()); 
        fluent.withSubject(instance.getSubject()); 
        this.validationEnabled = validationEnabled; 
    }


    public KafkaBindingSpecBuilder(KafkaBindingSpec instance) { 
        this(instance,true);
    }


    public KafkaBindingSpecBuilder(KafkaBindingSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withBootstrapServers(instance.getBootstrapServers()); 
        this.withNet(instance.getNet()); 
        this.withSubject(instance.getSubject()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.EditableKafkaBindingSpec build() {
        EditableKafkaBindingSpec buildable = new EditableKafkaBindingSpec(fluent.getBootstrapServers(),fluent.getNet(),fluent.getSubject());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBindingSpecBuilder that = (KafkaBindingSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
