package io.fabric8.knative.flows.v1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class SequenceSubscriptionStatusFluentImpl<A extends SequenceSubscriptionStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SequenceSubscriptionStatusFluent<A> {

    private ConditionBuilder ready;
    private ObjectReference subscription;

    public SequenceSubscriptionStatusFluentImpl() { 
    }


    public SequenceSubscriptionStatusFluentImpl(SequenceSubscriptionStatus instance) { 
        this.withReady(instance.getReady()); 
        this.withSubscription(instance.getSubscription()); 
    }


    
/**
 * This method has been deprecated, please use method buildReady instead.
 * @return The buildable object.
 */
@Deprecated public Condition getReady() {
        return this.ready!=null?this.ready.build():null;
    }

    public Condition buildReady() {
        return this.ready!=null?this.ready.build():null;
    }

    public A withReady(Condition ready) {
        _visitables.get("ready").remove(this.ready);
        if (ready!=null){ this.ready= new ConditionBuilder(ready); _visitables.get("ready").add(this.ready);} return (A) this;
    }

    public Boolean hasReady() {
        return this.ready != null;
    }

    public SequenceSubscriptionStatusFluent.ReadyNested<A> withNewReady() {
        return new ReadyNestedImpl();
    }

    public SequenceSubscriptionStatusFluent.ReadyNested<A> withNewReadyLike(Condition item) {
        return new ReadyNestedImpl(item);
    }

    public SequenceSubscriptionStatusFluent.ReadyNested<A> editReady() {
        return withNewReadyLike(getReady());
    }

    public SequenceSubscriptionStatusFluent.ReadyNested<A> editOrNewReady() {
        return withNewReadyLike(getReady() != null ? getReady(): new ConditionBuilder().build());
    }

    public SequenceSubscriptionStatusFluent.ReadyNested<A> editOrNewReadyLike(Condition item) {
        return withNewReadyLike(getReady() != null ? getReady(): item);
    }

    public ObjectReference getSubscription() {
        return this.subscription;
    }

    public A withSubscription(ObjectReference subscription) {
        this.subscription=subscription; return (A) this;
    }

    public Boolean hasSubscription() {
        return this.subscription != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SequenceSubscriptionStatusFluentImpl that = (SequenceSubscriptionStatusFluentImpl) o;
        if (ready != null ? !ready.equals(that.ready) :that.ready != null) return false;
        if (subscription != null ? !subscription.equals(that.subscription) :that.subscription != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ready,  subscription,  super.hashCode());
    }

    public class ReadyNestedImpl<N> extends ConditionFluentImpl<SequenceSubscriptionStatusFluent.ReadyNested<N>> implements SequenceSubscriptionStatusFluent.ReadyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConditionBuilder builder;

        ReadyNestedImpl(Condition item) {
            this.builder = new ConditionBuilder(this, item);
        }

        ReadyNestedImpl() {
            this.builder = new ConditionBuilder(this);
        }

        public N and() {
             return (N) SequenceSubscriptionStatusFluentImpl.this.withReady(builder.build());
        }

        public N endReady() {
             return and();
        }
    }


}
