package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitHubSourceStatusBuilder extends GitHubSourceStatusFluentImpl<GitHubSourceStatusBuilder> implements VisitableBuilder<GitHubSourceStatus,GitHubSourceStatusBuilder> {

    GitHubSourceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public GitHubSourceStatusBuilder() { 
        this(true);
    }


    public GitHubSourceStatusBuilder(Boolean validationEnabled) { 
        this(new GitHubSourceStatus(), validationEnabled);
    }


    public GitHubSourceStatusBuilder(GitHubSourceStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public GitHubSourceStatusBuilder(GitHubSourceStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new GitHubSourceStatus(), validationEnabled);
    }


    public GitHubSourceStatusBuilder(GitHubSourceStatusFluent<?> fluent,GitHubSourceStatus instance) { 
        this(fluent, instance, true);
    }


    public GitHubSourceStatusBuilder(GitHubSourceStatusFluent<?> fluent,GitHubSourceStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withCeAttributes(instance.getCeAttributes()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSinkUri(instance.getSinkUri()); 
        fluent.withWebhookIDKey(instance.getWebhookIDKey()); 
        this.validationEnabled = validationEnabled; 
    }


    public GitHubSourceStatusBuilder(GitHubSourceStatus instance) { 
        this(instance,true);
    }


    public GitHubSourceStatusBuilder(GitHubSourceStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withCeAttributes(instance.getCeAttributes()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSinkUri(instance.getSinkUri()); 
        this.withWebhookIDKey(instance.getWebhookIDKey()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.eventing.contrib.github.v1alpha1.EditableGitHubSourceStatus build() {
        EditableGitHubSourceStatus buildable = new EditableGitHubSourceStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri(),fluent.getWebhookIDKey());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitHubSourceStatusBuilder that = (GitHubSourceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
