package io.fabric8.knative.messaging.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;
import java.lang.Boolean;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;

public class SubscriptionSpecFluentImpl<A extends SubscriptionSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubscriptionSpecFluent<A> {

    private ObjectReference channel;
    private DeliverySpecBuilder delivery;
    private DestinationBuilder reply;
    private DestinationBuilder subscriber;

    public SubscriptionSpecFluentImpl() { 
    }


    public SubscriptionSpecFluentImpl(SubscriptionSpec instance) { 
        this.withChannel(instance.getChannel()); 
        this.withDelivery(instance.getDelivery()); 
        this.withReply(instance.getReply()); 
        this.withSubscriber(instance.getSubscriber()); 
    }


    public ObjectReference getChannel() {
        return this.channel;
    }

    public A withChannel(ObjectReference channel) {
        this.channel=channel; return (A) this;
    }

    public Boolean hasChannel() {
        return this.channel != null;
    }

    
/**
 * This method has been deprecated, please use method buildDelivery instead.
 * @return The buildable object.
 */
@Deprecated public DeliverySpec getDelivery() {
        return this.delivery!=null?this.delivery.build():null;
    }

    public DeliverySpec buildDelivery() {
        return this.delivery!=null?this.delivery.build():null;
    }

    public A withDelivery(DeliverySpec delivery) {
        _visitables.get("delivery").remove(this.delivery);
        if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} return (A) this;
    }

    public Boolean hasDelivery() {
        return this.delivery != null;
    }

    public SubscriptionSpecFluent.DeliveryNested<A> withNewDelivery() {
        return new DeliveryNestedImpl();
    }

    public SubscriptionSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNestedImpl(item);
    }

    public SubscriptionSpecFluent.DeliveryNested<A> editDelivery() {
        return withNewDeliveryLike(getDelivery());
    }

    public SubscriptionSpecFluent.DeliveryNested<A> editOrNewDelivery() {
        return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new DeliverySpecBuilder().build());
    }

    public SubscriptionSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
    }

    
/**
 * This method has been deprecated, please use method buildReply instead.
 * @return The buildable object.
 */
@Deprecated public Destination getReply() {
        return this.reply!=null?this.reply.build():null;
    }

    public Destination buildReply() {
        return this.reply!=null?this.reply.build():null;
    }

    public A withReply(Destination reply) {
        _visitables.get("reply").remove(this.reply);
        if (reply!=null){ this.reply= new DestinationBuilder(reply); _visitables.get("reply").add(this.reply);} return (A) this;
    }

    public Boolean hasReply() {
        return this.reply != null;
    }

    public SubscriptionSpecFluent.ReplyNested<A> withNewReply() {
        return new ReplyNestedImpl();
    }

    public SubscriptionSpecFluent.ReplyNested<A> withNewReplyLike(Destination item) {
        return new ReplyNestedImpl(item);
    }

    public SubscriptionSpecFluent.ReplyNested<A> editReply() {
        return withNewReplyLike(getReply());
    }

    public SubscriptionSpecFluent.ReplyNested<A> editOrNewReply() {
        return withNewReplyLike(getReply() != null ? getReply(): new DestinationBuilder().build());
    }

    public SubscriptionSpecFluent.ReplyNested<A> editOrNewReplyLike(Destination item) {
        return withNewReplyLike(getReply() != null ? getReply(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSubscriber instead.
 * @return The buildable object.
 */
@Deprecated public Destination getSubscriber() {
        return this.subscriber!=null?this.subscriber.build():null;
    }

    public Destination buildSubscriber() {
        return this.subscriber!=null?this.subscriber.build():null;
    }

    public A withSubscriber(Destination subscriber) {
        _visitables.get("subscriber").remove(this.subscriber);
        if (subscriber!=null){ this.subscriber= new DestinationBuilder(subscriber); _visitables.get("subscriber").add(this.subscriber);} return (A) this;
    }

    public Boolean hasSubscriber() {
        return this.subscriber != null;
    }

    public SubscriptionSpecFluent.SubscriberNested<A> withNewSubscriber() {
        return new SubscriberNestedImpl();
    }

    public SubscriptionSpecFluent.SubscriberNested<A> withNewSubscriberLike(Destination item) {
        return new SubscriberNestedImpl(item);
    }

    public SubscriptionSpecFluent.SubscriberNested<A> editSubscriber() {
        return withNewSubscriberLike(getSubscriber());
    }

    public SubscriptionSpecFluent.SubscriberNested<A> editOrNewSubscriber() {
        return withNewSubscriberLike(getSubscriber() != null ? getSubscriber(): new DestinationBuilder().build());
    }

    public SubscriptionSpecFluent.SubscriberNested<A> editOrNewSubscriberLike(Destination item) {
        return withNewSubscriberLike(getSubscriber() != null ? getSubscriber(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubscriptionSpecFluentImpl that = (SubscriptionSpecFluentImpl) o;
        if (channel != null ? !channel.equals(that.channel) :that.channel != null) return false;
        if (delivery != null ? !delivery.equals(that.delivery) :that.delivery != null) return false;
        if (reply != null ? !reply.equals(that.reply) :that.reply != null) return false;
        if (subscriber != null ? !subscriber.equals(that.subscriber) :that.subscriber != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(channel,  delivery,  reply,  subscriber,  super.hashCode());
    }

    public class DeliveryNestedImpl<N> extends DeliverySpecFluentImpl<SubscriptionSpecFluent.DeliveryNested<N>> implements SubscriptionSpecFluent.DeliveryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DeliverySpecBuilder builder;

        DeliveryNestedImpl(DeliverySpec item) {
            this.builder = new DeliverySpecBuilder(this, item);
        }

        DeliveryNestedImpl() {
            this.builder = new DeliverySpecBuilder(this);
        }

        public N and() {
             return (N) SubscriptionSpecFluentImpl.this.withDelivery(builder.build());
        }

        public N endDelivery() {
             return and();
        }
    }


    public class ReplyNestedImpl<N> extends DestinationFluentImpl<SubscriptionSpecFluent.ReplyNested<N>> implements SubscriptionSpecFluent.ReplyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DestinationBuilder builder;

        ReplyNestedImpl(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        ReplyNestedImpl() {
            this.builder = new DestinationBuilder(this);
        }

        public N and() {
             return (N) SubscriptionSpecFluentImpl.this.withReply(builder.build());
        }

        public N endReply() {
             return and();
        }
    }


    public class SubscriberNestedImpl<N> extends DestinationFluentImpl<SubscriptionSpecFluent.SubscriberNested<N>> implements SubscriptionSpecFluent.SubscriberNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DestinationBuilder builder;

        SubscriberNestedImpl(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        SubscriberNestedImpl() {
            this.builder = new DestinationBuilder(this);
        }

        public N and() {
             return (N) SubscriptionSpecFluentImpl.this.withSubscriber(builder.build());
        }

        public N endSubscriber() {
             return and();
        }
    }


}
