package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ConfigurationStatusFluent<A extends ConfigurationStatusFluent<A>> extends Fluent<A> {


    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public A withAnnotations(Map<String,String> annotations);
    public Boolean hasAnnotations();
    public A addToConditions(int index,Condition item);
    public A setToConditions(int index,Condition item);
    public A addToConditions(Condition... items);
    public A addAllToConditions(Collection<Condition> items);
    public A removeFromConditions(Condition... items);
    public A removeAllFromConditions(Collection<Condition> items);
    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions();
    public List<Condition> buildConditions();
    public Condition buildCondition(int index);
    public Condition buildFirstCondition();
    public Condition buildLastCondition();
    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate);
    public A withConditions(List<Condition> conditions);
    public A withConditions(Condition... conditions);
    public Boolean hasConditions();
    public ConfigurationStatusFluent.ConditionsNested<A> addNewCondition();
    public ConfigurationStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item);
    public ConfigurationStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item);
    public ConfigurationStatusFluent.ConditionsNested<A> editCondition(int index);
    public ConfigurationStatusFluent.ConditionsNested<A> editFirstCondition();
    public ConfigurationStatusFluent.ConditionsNested<A> editLastCondition();
    public ConfigurationStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate);
    public String getLatestCreatedRevisionName();
    public A withLatestCreatedRevisionName(String latestCreatedRevisionName);
    public Boolean hasLatestCreatedRevisionName();
    public A withNewLatestCreatedRevisionName(String arg1);
    public A withNewLatestCreatedRevisionName(StringBuilder arg1);
    public A withNewLatestCreatedRevisionName(StringBuffer arg1);
    public String getLatestReadyRevisionName();
    public A withLatestReadyRevisionName(String latestReadyRevisionName);
    public Boolean hasLatestReadyRevisionName();
    public A withNewLatestReadyRevisionName(String arg1);
    public A withNewLatestReadyRevisionName(StringBuilder arg1);
    public A withNewLatestReadyRevisionName(StringBuffer arg1);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConditionFluent<ConfigurationStatusFluent.ConditionsNested<N>> {

        public N and();
        public N endCondition();    }


}
