package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

public class GitLabSourceSpecFluentImpl<A extends GitLabSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GitLabSourceSpecFluent<A> {

    private io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceBuilder accessToken;
    private List<String> eventTypes;
    private String projectUrl;
    private io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceBuilder secretToken;
    private String serviceAccountName;
    private DestinationBuilder sink;
    private Boolean sslverify;

    public GitLabSourceSpecFluentImpl() {
    }

    public GitLabSourceSpecFluentImpl(GitLabSourceSpec instance) {
        this.withAccessToken(instance.getAccessToken()); 
        this.withEventTypes(instance.getEventTypes()); 
        this.withProjectUrl(instance.getProjectUrl()); 
        this.withSecretToken(instance.getSecretToken()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSink(instance.getSink()); 
        this.withSslverify(instance.getSslverify()); 
    }

    
/**
 * This method has been deprecated, please use method buildAccessToken instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSource getAccessToken() {
        return this.accessToken!=null?this.accessToken.build():null;
    }

    public io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSource buildAccessToken() {
        return this.accessToken!=null?this.accessToken.build():null;
    }

    public A withAccessToken(io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSource accessToken) {
        _visitables.get("accessToken").remove(this.accessToken);
        if (accessToken!=null){ this.accessToken= new io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceBuilder(accessToken); _visitables.get("accessToken").add(this.accessToken);} return (A) this;
    }

    public Boolean hasAccessToken() {
        return this.accessToken != null;
    }

    public GitLabSourceSpecFluent.AccessTokenNested<A> withNewAccessToken() {
        return new AccessTokenNestedImpl();
    }

    public GitLabSourceSpecFluent.AccessTokenNested<A> withNewAccessTokenLike(io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSource item) {
        return new AccessTokenNestedImpl(item);
    }

    public GitLabSourceSpecFluent.AccessTokenNested<A> editAccessToken() {
        return withNewAccessTokenLike(getAccessToken());
    }

    public GitLabSourceSpecFluent.AccessTokenNested<A> editOrNewAccessToken() {
        return withNewAccessTokenLike(getAccessToken() != null ? getAccessToken(): new io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceBuilder().build());
    }

    public GitLabSourceSpecFluent.AccessTokenNested<A> editOrNewAccessTokenLike(io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSource item) {
        return withNewAccessTokenLike(getAccessToken() != null ? getAccessToken(): item);
    }

    public A addToEventTypes(int index,String item) {
        if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
        this.eventTypes.add(index, item);
        return (A)this;
    }

    public A setToEventTypes(int index,String item) {
        if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
        this.eventTypes.set(index, item); return (A)this;
    }

    public A addToEventTypes(String... items) {
        if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
        for (String item : items) {this.eventTypes.add(item);} return (A)this;
    }

    public A addAllToEventTypes(Collection<String> items) {
        if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
        for (String item : items) {this.eventTypes.add(item);} return (A)this;
    }

    public A removeFromEventTypes(String... items) {
        for (String item : items) {if (this.eventTypes!= null){ this.eventTypes.remove(item);}} return (A)this;
    }

    public A removeAllFromEventTypes(Collection<String> items) {
        for (String item : items) {if (this.eventTypes!= null){ this.eventTypes.remove(item);}} return (A)this;
    }

    public List<String> getEventTypes() {
        return this.eventTypes;
    }

    public String getEventType(int index) {
        return this.eventTypes.get(index);
    }

    public String getFirstEventType() {
        return this.eventTypes.get(0);
    }

    public String getLastEventType() {
        return this.eventTypes.get(eventTypes.size() - 1);
    }

    public String getMatchingEventType(Predicate<String> predicate) {
        for (String item: eventTypes) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEventType(Predicate<String> predicate) {
        for (String item: eventTypes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEventTypes(List<String> eventTypes) {
        if (this.eventTypes != null) { _visitables.get("eventTypes").removeAll(this.eventTypes);}
        if (eventTypes != null) {this.eventTypes = new ArrayList<String>(); for (String item : eventTypes){this.addToEventTypes(item);}} else { this.eventTypes = null;} return (A) this;
    }

    public A withEventTypes(String... eventTypes) {
        if (this.eventTypes != null) {this.eventTypes.clear();}
        if (eventTypes != null) {for (String item :eventTypes){ this.addToEventTypes(item);}} return (A) this;
    }

    public Boolean hasEventTypes() {
        return eventTypes != null && !eventTypes.isEmpty();
    }

    public A addNewEventType(String arg1) {
        return (A)addToEventTypes(new String(arg1));
    }

    public A addNewEventType(StringBuilder arg1) {
        return (A)addToEventTypes(new String(arg1));
    }

    public A addNewEventType(StringBuffer arg1) {
        return (A)addToEventTypes(new String(arg1));
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public A withProjectUrl(String projectUrl) {
        this.projectUrl=projectUrl; return (A) this;
    }

    public Boolean hasProjectUrl() {
        return this.projectUrl != null;
    }

    public A withNewProjectUrl(String arg1) {
        return (A)withProjectUrl(new String(arg1));
    }

    public A withNewProjectUrl(StringBuilder arg1) {
        return (A)withProjectUrl(new String(arg1));
    }

    public A withNewProjectUrl(StringBuffer arg1) {
        return (A)withProjectUrl(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSecretToken instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSource getSecretToken() {
        return this.secretToken!=null?this.secretToken.build():null;
    }

    public io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSource buildSecretToken() {
        return this.secretToken!=null?this.secretToken.build():null;
    }

    public A withSecretToken(io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSource secretToken) {
        _visitables.get("secretToken").remove(this.secretToken);
        if (secretToken!=null){ this.secretToken= new io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceBuilder(secretToken); _visitables.get("secretToken").add(this.secretToken);} return (A) this;
    }

    public Boolean hasSecretToken() {
        return this.secretToken != null;
    }

    public GitLabSourceSpecFluent.SecretTokenNested<A> withNewSecretToken() {
        return new SecretTokenNestedImpl();
    }

    public GitLabSourceSpecFluent.SecretTokenNested<A> withNewSecretTokenLike(io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSource item) {
        return new SecretTokenNestedImpl(item);
    }

    public GitLabSourceSpecFluent.SecretTokenNested<A> editSecretToken() {
        return withNewSecretTokenLike(getSecretToken());
    }

    public GitLabSourceSpecFluent.SecretTokenNested<A> editOrNewSecretToken() {
        return withNewSecretTokenLike(getSecretToken() != null ? getSecretToken(): new io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceBuilder().build());
    }

    public GitLabSourceSpecFluent.SecretTokenNested<A> editOrNewSecretTokenLike(io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSource item) {
        return withNewSecretTokenLike(getSecretToken() != null ? getSecretToken(): item);
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@Deprecated public Destination getSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public Destination buildSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public A withSink(Destination sink) {
        _visitables.get("sink").remove(this.sink);
        if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} return (A) this;
    }

    public Boolean hasSink() {
        return this.sink != null;
    }

    public GitLabSourceSpecFluent.SinkNested<A> withNewSink() {
        return new SinkNestedImpl();
    }

    public GitLabSourceSpecFluent.SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNestedImpl(item);
    }

    public GitLabSourceSpecFluent.SinkNested<A> editSink() {
        return withNewSinkLike(getSink());
    }

    public GitLabSourceSpecFluent.SinkNested<A> editOrNewSink() {
        return withNewSinkLike(getSink() != null ? getSink(): new DestinationBuilder().build());
    }

    public GitLabSourceSpecFluent.SinkNested<A> editOrNewSinkLike(Destination item) {
        return withNewSinkLike(getSink() != null ? getSink(): item);
    }

    public Boolean isSslverify() {
        return this.sslverify;
    }

    public A withSslverify(Boolean sslverify) {
        this.sslverify=sslverify; return (A) this;
    }

    public Boolean hasSslverify() {
        return this.sslverify != null;
    }

    public A withNewSslverify(String arg1) {
        return (A)withSslverify(new Boolean(arg1));
    }

    public A withNewSslverify(boolean arg1) {
        return (A)withSslverify(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GitLabSourceSpecFluentImpl that = (GitLabSourceSpecFluentImpl) o;
        if (accessToken != null ? !accessToken.equals(that.accessToken) :that.accessToken != null) return false;
        if (eventTypes != null ? !eventTypes.equals(that.eventTypes) :that.eventTypes != null) return false;
        if (projectUrl != null ? !projectUrl.equals(that.projectUrl) :that.projectUrl != null) return false;
        if (secretToken != null ? !secretToken.equals(that.secretToken) :that.secretToken != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
        if (sslverify != null ? !sslverify.equals(that.sslverify) :that.sslverify != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(accessToken,  eventTypes,  projectUrl,  secretToken,  serviceAccountName,  sink,  sslverify,  super.hashCode());
    }

    public class AccessTokenNestedImpl<N> extends io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceFluentImpl<GitLabSourceSpecFluent.AccessTokenNested<N>> implements GitLabSourceSpecFluent.AccessTokenNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceBuilder builder;

            AccessTokenNestedImpl(io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSource item) {
                this.builder = new io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceBuilder(this, item);
                        
            }

            AccessTokenNestedImpl() {
                this.builder = new io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceBuilder(this);
                        
            }

            public N and() {
                return (N) GitLabSourceSpecFluentImpl.this.withAccessToken(builder.build());
            }

            public N endAccessToken() {
                return and();
            }
    }


    public class SecretTokenNestedImpl<N> extends io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceFluentImpl<GitLabSourceSpecFluent.SecretTokenNested<N>> implements GitLabSourceSpecFluent.SecretTokenNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceBuilder builder;

            SecretTokenNestedImpl(io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSource item) {
                this.builder = new io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceBuilder(this, item);
                        
            }

            SecretTokenNestedImpl() {
                this.builder = new io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.SecretValueFromSourceBuilder(this);
                        
            }

            public N and() {
                return (N) GitLabSourceSpecFluentImpl.this.withSecretToken(builder.build());
            }

            public N endSecretToken() {
                return and();
            }
    }


    public class SinkNestedImpl<N> extends DestinationFluentImpl<GitLabSourceSpecFluent.SinkNested<N>> implements GitLabSourceSpecFluent.SinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DestinationBuilder builder;

            SinkNestedImpl(Destination item) {
                this.builder = new DestinationBuilder(this, item);
                        
            }

            SinkNestedImpl() {
                this.builder = new DestinationBuilder(this);
                        
            }

            public N and() {
                return (N) GitLabSourceSpecFluentImpl.this.withSink(builder.build());
            }

            public N endSink() {
                return and();
            }
    }


}
