package io.fabric8.knative.serving.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConfigurationListBuilder extends io.fabric8.knative.serving.v1beta1.ConfigurationListFluentImpl<io.fabric8.knative.serving.v1beta1.ConfigurationListBuilder> implements VisitableBuilder<io.fabric8.knative.serving.v1beta1.ConfigurationList,io.fabric8.knative.serving.v1beta1.ConfigurationListBuilder> {

    io.fabric8.knative.serving.v1beta1.ConfigurationListFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigurationListBuilder() {
        this(true);
    }

    public ConfigurationListBuilder(Boolean validationEnabled) {
        this(new ConfigurationList(), validationEnabled);
    }

    public ConfigurationListBuilder(io.fabric8.knative.serving.v1beta1.ConfigurationListFluent<?> fluent) {
        this(fluent, true);
    }

    public ConfigurationListBuilder(io.fabric8.knative.serving.v1beta1.ConfigurationListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ConfigurationList(), validationEnabled);
    }

    public ConfigurationListBuilder(io.fabric8.knative.serving.v1beta1.ConfigurationListFluent<?> fluent,io.fabric8.knative.serving.v1beta1.ConfigurationList instance) {
        this(fluent, instance, true);
    }

    public ConfigurationListBuilder(io.fabric8.knative.serving.v1beta1.ConfigurationListFluent<?> fluent,io.fabric8.knative.serving.v1beta1.ConfigurationList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConfigurationListBuilder(io.fabric8.knative.serving.v1beta1.ConfigurationList instance) {
        this(instance,true);
    }

    public ConfigurationListBuilder(io.fabric8.knative.serving.v1beta1.ConfigurationList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.serving.v1beta1.EditableConfigurationList build() {
        EditableConfigurationList buildable = new EditableConfigurationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConfigurationListBuilder that = (ConfigurationListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
