package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitHubBindingListBuilder extends GitHubBindingListFluentImpl<GitHubBindingListBuilder> implements VisitableBuilder<GitHubBindingList,GitHubBindingListBuilder> {

    GitHubBindingListFluent<?> fluent;
    Boolean validationEnabled;

    public GitHubBindingListBuilder() {
        this(true);
    }

    public GitHubBindingListBuilder(Boolean validationEnabled) {
        this(new GitHubBindingList(), validationEnabled);
    }

    public GitHubBindingListBuilder(GitHubBindingListFluent<?> fluent) {
        this(fluent, true);
    }

    public GitHubBindingListBuilder(GitHubBindingListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new GitHubBindingList(), validationEnabled);
    }

    public GitHubBindingListBuilder(GitHubBindingListFluent<?> fluent,GitHubBindingList instance) {
        this(fluent, instance, true);
    }

    public GitHubBindingListBuilder(GitHubBindingListFluent<?> fluent,GitHubBindingList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public GitHubBindingListBuilder(GitHubBindingList instance) {
        this(instance,true);
    }

    public GitHubBindingListBuilder(GitHubBindingList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.EditableGitHubBindingList build() {
        EditableGitHubBindingList buildable = new EditableGitHubBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitHubBindingListBuilder that = (GitHubBindingListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
