package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BrokerListBuilder extends BrokerListFluentImpl<BrokerListBuilder> implements VisitableBuilder<BrokerList,BrokerListBuilder> {

    BrokerListFluent<?> fluent;
    Boolean validationEnabled;

    public BrokerListBuilder() {
        this(true);
    }

    public BrokerListBuilder(Boolean validationEnabled) {
        this(new BrokerList(), validationEnabled);
    }

    public BrokerListBuilder(BrokerListFluent<?> fluent) {
        this(fluent, true);
    }

    public BrokerListBuilder(BrokerListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new BrokerList(), validationEnabled);
    }

    public BrokerListBuilder(BrokerListFluent<?> fluent,BrokerList instance) {
        this(fluent, instance, true);
    }

    public BrokerListBuilder(BrokerListFluent<?> fluent,BrokerList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public BrokerListBuilder(BrokerList instance) {
        this(instance,true);
    }

    public BrokerListBuilder(BrokerList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.v1.EditableBrokerList build() {
        EditableBrokerList buildable = new EditableBrokerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BrokerListBuilder that = (BrokerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
