package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CloudEventAttributesBuilder extends CloudEventAttributesFluentImpl<CloudEventAttributesBuilder> implements VisitableBuilder<CloudEventAttributes,CloudEventAttributesBuilder> {

    CloudEventAttributesFluent<?> fluent;
    Boolean validationEnabled;

    public CloudEventAttributesBuilder() {
        this(true);
    }

    public CloudEventAttributesBuilder(Boolean validationEnabled) {
        this(new CloudEventAttributes(), validationEnabled);
    }

    public CloudEventAttributesBuilder(CloudEventAttributesFluent<?> fluent) {
        this(fluent, true);
    }

    public CloudEventAttributesBuilder(CloudEventAttributesFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CloudEventAttributes(), validationEnabled);
    }

    public CloudEventAttributesBuilder(CloudEventAttributesFluent<?> fluent,CloudEventAttributes instance) {
        this(fluent, instance, true);
    }

    public CloudEventAttributesBuilder(CloudEventAttributesFluent<?> fluent,CloudEventAttributes instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSource(instance.getSource()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public CloudEventAttributesBuilder(CloudEventAttributes instance) {
        this(instance,true);
    }

    public CloudEventAttributesBuilder(CloudEventAttributes instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withSource(instance.getSource()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.internal.pkg.apis.duck.v1.EditableCloudEventAttributes build() {
        EditableCloudEventAttributes buildable = new EditableCloudEventAttributes(fluent.getSource(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CloudEventAttributesBuilder that = (CloudEventAttributesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
