package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RevisionStatusBuilder extends RevisionStatusFluentImpl<RevisionStatusBuilder> implements VisitableBuilder<RevisionStatus,RevisionStatusBuilder> {

    RevisionStatusFluent<?> fluent;
    Boolean validationEnabled;

    public RevisionStatusBuilder() {
        this(true);
    }

    public RevisionStatusBuilder(Boolean validationEnabled) {
        this(new RevisionStatus(), validationEnabled);
    }

    public RevisionStatusBuilder(RevisionStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public RevisionStatusBuilder(RevisionStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new RevisionStatus(), validationEnabled);
    }

    public RevisionStatusBuilder(RevisionStatusFluent<?> fluent,RevisionStatus instance) {
        this(fluent, instance, true);
    }

    public RevisionStatusBuilder(RevisionStatusFluent<?> fluent,RevisionStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withContainerStatuses(instance.getContainerStatuses()); 
        fluent.withImageDigest(instance.getImageDigest()); 
        fluent.withLogUrl(instance.getLogUrl()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withServiceName(instance.getServiceName()); 
        this.validationEnabled = validationEnabled; 
    }

    public RevisionStatusBuilder(RevisionStatus instance) {
        this(instance,true);
    }

    public RevisionStatusBuilder(RevisionStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withContainerStatuses(instance.getContainerStatuses()); 
        this.withImageDigest(instance.getImageDigest()); 
        this.withLogUrl(instance.getLogUrl()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withServiceName(instance.getServiceName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.serving.v1.EditableRevisionStatus build() {
        EditableRevisionStatus buildable = new EditableRevisionStatus(fluent.getAnnotations(),fluent.getConditions(),fluent.getContainerStatuses(),fluent.getImageDigest(),fluent.getLogUrl(),fluent.getObservedGeneration(),fluent.getServiceName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RevisionStatusBuilder that = (RevisionStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
