package io.fabric8.knative.eventing.contrib.awssqs.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AwsSqsSourceListBuilder extends AwsSqsSourceListFluentImpl<AwsSqsSourceListBuilder> implements VisitableBuilder<AwsSqsSourceList,AwsSqsSourceListBuilder> {

    AwsSqsSourceListFluent<?> fluent;
    Boolean validationEnabled;

    public AwsSqsSourceListBuilder() {
        this(true);
    }

    public AwsSqsSourceListBuilder(Boolean validationEnabled) {
        this(new AwsSqsSourceList(), validationEnabled);
    }

    public AwsSqsSourceListBuilder(AwsSqsSourceListFluent<?> fluent) {
        this(fluent, true);
    }

    public AwsSqsSourceListBuilder(AwsSqsSourceListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AwsSqsSourceList(), validationEnabled);
    }

    public AwsSqsSourceListBuilder(AwsSqsSourceListFluent<?> fluent,AwsSqsSourceList instance) {
        this(fluent, instance, true);
    }

    public AwsSqsSourceListBuilder(AwsSqsSourceListFluent<?> fluent,AwsSqsSourceList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public AwsSqsSourceListBuilder(AwsSqsSourceList instance) {
        this(instance,true);
    }

    public AwsSqsSourceListBuilder(AwsSqsSourceList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.EditableAwsSqsSourceList build() {
        EditableAwsSqsSourceList buildable = new EditableAwsSqsSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AwsSqsSourceListBuilder that = (AwsSqsSourceListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
