package io.fabric8.knative.eventing.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class TriggerFilterFluentImpl<A extends TriggerFilterFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TriggerFilterFluent<A> {

    private Map<String,String> attributes;

    public TriggerFilterFluentImpl() {
    }

    public TriggerFilterFluentImpl(TriggerFilter instance) {
        this.withAttributes(instance.getAttributes()); 
    }

    public A addToAttributes(String key,String value) {
        if(this.attributes == null && key != null && value != null) { this.attributes = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.attributes.put(key, value);} return (A)this;
    }

    public A addToAttributes(Map<String,String> map) {
        if(this.attributes == null && map != null) { this.attributes = new LinkedHashMap<String,String>(); }
        if(map != null) { this.attributes.putAll(map);} return (A)this;
    }

    public A removeFromAttributes(String key) {
        if(this.attributes == null) { return (A) this; }
        if(key != null && this.attributes != null) {this.attributes.remove(key);} return (A)this;
    }

    public A removeFromAttributes(Map<String,String> map) {
        if(this.attributes == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.attributes != null){this.attributes.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAttributes() {
        return this.attributes;
    }

    public A withAttributes(Map<String,String> attributes) {
        if (attributes == null) { this.attributes =  null;} else {this.attributes = new LinkedHashMap<String,String>(attributes);} return (A) this;
    }

    public Boolean hasAttributes() {
        return this.attributes != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TriggerFilterFluentImpl that = (TriggerFilterFluentImpl) o;
        if (attributes != null ? !attributes.equals(that.attributes) :that.attributes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(attributes,  super.hashCode());
    }

}
