package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ChannelStatusBuilder extends ChannelStatusFluentImpl<ChannelStatusBuilder> implements VisitableBuilder<ChannelStatus,ChannelStatusBuilder> {

    ChannelStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ChannelStatusBuilder() {
        this(true);
    }

    public ChannelStatusBuilder(Boolean validationEnabled) {
        this(new ChannelStatus(), validationEnabled);
    }

    public ChannelStatusBuilder(ChannelStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ChannelStatusBuilder(ChannelStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ChannelStatus(), validationEnabled);
    }

    public ChannelStatusBuilder(ChannelStatusFluent<?> fluent,ChannelStatus instance) {
        this(fluent, instance, true);
    }

    public ChannelStatusBuilder(ChannelStatusFluent<?> fluent,ChannelStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAddress(instance.getAddress()); 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withChannel(instance.getChannel()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withDeadLetterChannel(instance.getDeadLetterChannel()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSubscribers(instance.getSubscribers()); 
        this.validationEnabled = validationEnabled; 
    }

    public ChannelStatusBuilder(ChannelStatus instance) {
        this(instance,true);
    }

    public ChannelStatusBuilder(ChannelStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAddress(instance.getAddress()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withChannel(instance.getChannel()); 
        this.withConditions(instance.getConditions()); 
        this.withDeadLetterChannel(instance.getDeadLetterChannel()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSubscribers(instance.getSubscribers()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.messaging.v1.EditableChannelStatus build() {
        EditableChannelStatus buildable = new EditableChannelStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getChannel(),fluent.getConditions(),fluent.getDeadLetterChannel(),fluent.getObservedGeneration(),fluent.getSubscribers());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ChannelStatusBuilder that = (ChannelStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
