package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerSourceSpecBuilder extends ContainerSourceSpecFluentImpl<ContainerSourceSpecBuilder> implements VisitableBuilder<ContainerSourceSpec,ContainerSourceSpecBuilder> {

    ContainerSourceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerSourceSpecBuilder() {
        this(true);
    }

    public ContainerSourceSpecBuilder(Boolean validationEnabled) {
        this(new ContainerSourceSpec(), validationEnabled);
    }

    public ContainerSourceSpecBuilder(ContainerSourceSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ContainerSourceSpecBuilder(ContainerSourceSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ContainerSourceSpec(), validationEnabled);
    }

    public ContainerSourceSpecBuilder(ContainerSourceSpecFluent<?> fluent,ContainerSourceSpec instance) {
        this(fluent, instance, true);
    }

    public ContainerSourceSpecBuilder(ContainerSourceSpecFluent<?> fluent,ContainerSourceSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCeOverrides(instance.getCeOverrides()); 
        fluent.withSink(instance.getSink()); 
        fluent.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public ContainerSourceSpecBuilder(ContainerSourceSpec instance) {
        this(instance,true);
    }

    public ContainerSourceSpecBuilder(ContainerSourceSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCeOverrides(instance.getCeOverrides()); 
        this.withSink(instance.getSink()); 
        this.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.sources.v1beta1.EditableContainerSourceSpec build() {
        EditableContainerSourceSpec buildable = new EditableContainerSourceSpec(fluent.getCeOverrides(),fluent.getSink(),fluent.getTemplate());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerSourceSpecBuilder that = (ContainerSourceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
