package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitHubBindingSpecBuilder extends GitHubBindingSpecFluentImpl<GitHubBindingSpecBuilder> implements VisitableBuilder<GitHubBindingSpec,GitHubBindingSpecBuilder> {

    GitHubBindingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public GitHubBindingSpecBuilder() {
        this(true);
    }

    public GitHubBindingSpecBuilder(Boolean validationEnabled) {
        this(new GitHubBindingSpec(), validationEnabled);
    }

    public GitHubBindingSpecBuilder(GitHubBindingSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public GitHubBindingSpecBuilder(GitHubBindingSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new GitHubBindingSpec(), validationEnabled);
    }

    public GitHubBindingSpecBuilder(GitHubBindingSpecFluent<?> fluent,GitHubBindingSpec instance) {
        this(fluent, instance, true);
    }

    public GitHubBindingSpecBuilder(GitHubBindingSpecFluent<?> fluent,GitHubBindingSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAccessToken(instance.getAccessToken()); 
        fluent.withSubject(instance.getSubject()); 
        this.validationEnabled = validationEnabled; 
    }

    public GitHubBindingSpecBuilder(GitHubBindingSpec instance) {
        this(instance,true);
    }

    public GitHubBindingSpecBuilder(GitHubBindingSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAccessToken(instance.getAccessToken()); 
        this.withSubject(instance.getSubject()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.EditableGitHubBindingSpec build() {
        EditableGitHubBindingSpec buildable = new EditableGitHubBindingSpec(fluent.getAccessToken(),fluent.getSubject());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitHubBindingSpecBuilder that = (GitHubBindingSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
