package io.fabric8.knative.eventing.contrib.prometheus.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PrometheusSourceListBuilder extends PrometheusSourceListFluentImpl<PrometheusSourceListBuilder> implements VisitableBuilder<PrometheusSourceList,PrometheusSourceListBuilder> {

    PrometheusSourceListFluent<?> fluent;
    Boolean validationEnabled;

    public PrometheusSourceListBuilder() {
        this(true);
    }

    public PrometheusSourceListBuilder(Boolean validationEnabled) {
        this(new PrometheusSourceList(), validationEnabled);
    }

    public PrometheusSourceListBuilder(PrometheusSourceListFluent<?> fluent) {
        this(fluent, true);
    }

    public PrometheusSourceListBuilder(PrometheusSourceListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PrometheusSourceList(), validationEnabled);
    }

    public PrometheusSourceListBuilder(PrometheusSourceListFluent<?> fluent,PrometheusSourceList instance) {
        this(fluent, instance, true);
    }

    public PrometheusSourceListBuilder(PrometheusSourceListFluent<?> fluent,PrometheusSourceList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public PrometheusSourceListBuilder(PrometheusSourceList instance) {
        this(instance,true);
    }

    public PrometheusSourceListBuilder(PrometheusSourceList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.EditablePrometheusSourceList build() {
        EditablePrometheusSourceList buildable = new EditablePrometheusSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PrometheusSourceListBuilder that = (PrometheusSourceListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
