package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InMemoryChannelListBuilder extends InMemoryChannelListFluentImpl<InMemoryChannelListBuilder> implements VisitableBuilder<InMemoryChannelList,InMemoryChannelListBuilder> {

    InMemoryChannelListFluent<?> fluent;
    Boolean validationEnabled;

    public InMemoryChannelListBuilder() {
        this(true);
    }

    public InMemoryChannelListBuilder(Boolean validationEnabled) {
        this(new InMemoryChannelList(), validationEnabled);
    }

    public InMemoryChannelListBuilder(InMemoryChannelListFluent<?> fluent) {
        this(fluent, true);
    }

    public InMemoryChannelListBuilder(InMemoryChannelListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new InMemoryChannelList(), validationEnabled);
    }

    public InMemoryChannelListBuilder(InMemoryChannelListFluent<?> fluent,InMemoryChannelList instance) {
        this(fluent, instance, true);
    }

    public InMemoryChannelListBuilder(InMemoryChannelListFluent<?> fluent,InMemoryChannelList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public InMemoryChannelListBuilder(InMemoryChannelList instance) {
        this(instance,true);
    }

    public InMemoryChannelListBuilder(InMemoryChannelList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.messaging.v1.EditableInMemoryChannelList build() {
        EditableInMemoryChannelList buildable = new EditableInMemoryChannelList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InMemoryChannelListBuilder that = (InMemoryChannelListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
