package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluentImpl;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import java.lang.Integer;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecBuilder;
import java.util.Collection;
import java.lang.Object;

public class KafkaChannelSpecFluentImpl<A extends KafkaChannelSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaChannelSpecFluent<A> {

    private DeliverySpecBuilder delivery;
    private Integer numPartitions;
    private Integer replicationFactor;
    private List<SubscriberSpecBuilder> subscribers;

    public KafkaChannelSpecFluentImpl() {
    }

    public KafkaChannelSpecFluentImpl(KafkaChannelSpec instance) {
        this.withDelivery(instance.getDelivery()); 
        this.withNumPartitions(instance.getNumPartitions()); 
        this.withReplicationFactor(instance.getReplicationFactor()); 
        this.withSubscribers(instance.getSubscribers()); 
    }

    
/**
 * This method has been deprecated, please use method buildDelivery instead.
 * @return The buildable object.
 */
@Deprecated public DeliverySpec getDelivery() {
        return this.delivery!=null?this.delivery.build():null;
    }

    public DeliverySpec buildDelivery() {
        return this.delivery!=null?this.delivery.build():null;
    }

    public A withDelivery(DeliverySpec delivery) {
        _visitables.get("delivery").remove(this.delivery);
        if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} return (A) this;
    }

    public Boolean hasDelivery() {
        return this.delivery != null;
    }

    public KafkaChannelSpecFluent.DeliveryNested<A> withNewDelivery() {
        return new DeliveryNestedImpl();
    }

    public KafkaChannelSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNestedImpl(item);
    }

    public KafkaChannelSpecFluent.DeliveryNested<A> editDelivery() {
        return withNewDeliveryLike(getDelivery());
    }

    public KafkaChannelSpecFluent.DeliveryNested<A> editOrNewDelivery() {
        return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new DeliverySpecBuilder().build());
    }

    public KafkaChannelSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
    }

    public Integer getNumPartitions() {
        return this.numPartitions;
    }

    public A withNumPartitions(Integer numPartitions) {
        this.numPartitions=numPartitions; return (A) this;
    }

    public Boolean hasNumPartitions() {
        return this.numPartitions != null;
    }

    public A withNewNumPartitions(String arg1) {
        return (A)withNumPartitions(new Integer(arg1));
    }

    public A withNewNumPartitions(int arg1) {
        return (A)withNumPartitions(new Integer(arg1));
    }

    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    public A withReplicationFactor(Integer replicationFactor) {
        this.replicationFactor=replicationFactor; return (A) this;
    }

    public Boolean hasReplicationFactor() {
        return this.replicationFactor != null;
    }

    public A withNewReplicationFactor(String arg1) {
        return (A)withReplicationFactor(new Integer(arg1));
    }

    public A withNewReplicationFactor(int arg1) {
        return (A)withReplicationFactor(new Integer(arg1));
    }

    public A addToSubscribers(int index,SubscriberSpec item) {
        if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
        SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").add(index >= 0 ? index : _visitables.get("subscribers").size(), builder);this.subscribers.add(index >= 0 ? index : subscribers.size(), builder); return (A)this;
    }

    public A setToSubscribers(int index,SubscriberSpec item) {
        if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
        SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("subscribers").size()) { _visitables.get("subscribers").add(builder); } else { _visitables.get("subscribers").set(index, builder);}
        if (index < 0 || index >= subscribers.size()) { subscribers.add(builder); } else { subscribers.set(index, builder);}
         return (A)this;
    }

    public A addToSubscribers(SubscriberSpec... items) {
        if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
        for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A addAllToSubscribers(Collection<SubscriberSpec> items) {
        if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
        for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A removeFromSubscribers(SubscriberSpec... items) {
        for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubscribers(Collection<SubscriberSpec> items) {
        for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSubscribers(Predicate<SubscriberSpecBuilder> predicate) {
        if (subscribers == null) return (A) this;
        final Iterator<SubscriberSpecBuilder> each = subscribers.iterator();
        final List visitables = _visitables.get("subscribers");
        while (each.hasNext()) {
          SubscriberSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSubscribers instead.
 * @return The buildable object.
 */
@Deprecated public List<SubscriberSpec> getSubscribers() {
        return build(subscribers);
    }

    public List<SubscriberSpec> buildSubscribers() {
        return build(subscribers);
    }

    public SubscriberSpec buildSubscriber(int index) {
        return this.subscribers.get(index).build();
    }

    public SubscriberSpec buildFirstSubscriber() {
        return this.subscribers.get(0).build();
    }

    public SubscriberSpec buildLastSubscriber() {
        return this.subscribers.get(subscribers.size() - 1).build();
    }

    public SubscriberSpec buildMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        for (SubscriberSpecBuilder item: subscribers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        for (SubscriberSpecBuilder item: subscribers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSubscribers(List<SubscriberSpec> subscribers) {
        if (this.subscribers != null) { _visitables.get("subscribers").removeAll(this.subscribers);}
        if (subscribers != null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>(); for (SubscriberSpec item : subscribers){this.addToSubscribers(item);}} else { this.subscribers = null;} return (A) this;
    }

    public A withSubscribers(SubscriberSpec... subscribers) {
        if (this.subscribers != null) {this.subscribers.clear();}
        if (subscribers != null) {for (SubscriberSpec item :subscribers){ this.addToSubscribers(item);}} return (A) this;
    }

    public Boolean hasSubscribers() {
        return subscribers != null && !subscribers.isEmpty();
    }

    public KafkaChannelSpecFluent.SubscribersNested<A> addNewSubscriber() {
        return new SubscribersNestedImpl();
    }

    public KafkaChannelSpecFluent.SubscribersNested<A> addNewSubscriberLike(SubscriberSpec item) {
        return new SubscribersNestedImpl(-1, item);
    }

    public KafkaChannelSpecFluent.SubscribersNested<A> setNewSubscriberLike(int index,SubscriberSpec item) {
        return new SubscribersNestedImpl(index, item);
    }

    public KafkaChannelSpecFluent.SubscribersNested<A> editSubscriber(int index) {
        if (subscribers.size() <= index) throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
        return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public KafkaChannelSpecFluent.SubscribersNested<A> editFirstSubscriber() {
        if (subscribers.size() == 0) throw new RuntimeException("Can't edit first subscribers. The list is empty.");
        return setNewSubscriberLike(0, buildSubscriber(0));
    }

    public KafkaChannelSpecFluent.SubscribersNested<A> editLastSubscriber() {
        int index = subscribers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last subscribers. The list is empty.");
        return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public KafkaChannelSpecFluent.SubscribersNested<A> editMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<subscribers.size();i++) { 
        if (predicate.test(subscribers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching subscribers. No match found.");
        return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaChannelSpecFluentImpl that = (KafkaChannelSpecFluentImpl) o;
        if (delivery != null ? !delivery.equals(that.delivery) :that.delivery != null) return false;
        if (numPartitions != null ? !numPartitions.equals(that.numPartitions) :that.numPartitions != null) return false;
        if (replicationFactor != null ? !replicationFactor.equals(that.replicationFactor) :that.replicationFactor != null) return false;
        if (subscribers != null ? !subscribers.equals(that.subscribers) :that.subscribers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(delivery,  numPartitions,  replicationFactor,  subscribers,  super.hashCode());
    }

    public class DeliveryNestedImpl<N> extends DeliverySpecFluentImpl<KafkaChannelSpecFluent.DeliveryNested<N>> implements KafkaChannelSpecFluent.DeliveryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DeliverySpecBuilder builder;

            DeliveryNestedImpl(DeliverySpec item) {
                this.builder = new DeliverySpecBuilder(this, item);
                        
            }

            DeliveryNestedImpl() {
                this.builder = new DeliverySpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaChannelSpecFluentImpl.this.withDelivery(builder.build());
            }

            public N endDelivery() {
                return and();
            }
    }


    public class SubscribersNestedImpl<N> extends SubscriberSpecFluentImpl<KafkaChannelSpecFluent.SubscribersNested<N>> implements KafkaChannelSpecFluent.SubscribersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SubscriberSpecBuilder builder;
        private final int index;

            SubscribersNestedImpl(int index,SubscriberSpec item) {
                this.index = index;
                this.builder = new SubscriberSpecBuilder(this, item);
                        
            }

            SubscribersNestedImpl() {
                this.index = -1;
                this.builder = new SubscriberSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaChannelSpecFluentImpl.this.setToSubscribers(index,builder.build());
            }

            public N endSubscriber() {
                return and();
            }
    }


}
