package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CloudEventOverridesBuilder extends CloudEventOverridesFluentImpl<CloudEventOverridesBuilder> implements VisitableBuilder<CloudEventOverrides,CloudEventOverridesBuilder> {

    CloudEventOverridesFluent<?> fluent;
    Boolean validationEnabled;

    public CloudEventOverridesBuilder() {
        this(true);
    }

    public CloudEventOverridesBuilder(Boolean validationEnabled) {
        this(new CloudEventOverrides(), validationEnabled);
    }

    public CloudEventOverridesBuilder(CloudEventOverridesFluent<?> fluent) {
        this(fluent, true);
    }

    public CloudEventOverridesBuilder(CloudEventOverridesFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CloudEventOverrides(), validationEnabled);
    }

    public CloudEventOverridesBuilder(CloudEventOverridesFluent<?> fluent,CloudEventOverrides instance) {
        this(fluent, instance, true);
    }

    public CloudEventOverridesBuilder(CloudEventOverridesFluent<?> fluent,CloudEventOverrides instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withExtensions(instance.getExtensions()); 
        this.validationEnabled = validationEnabled; 
    }

    public CloudEventOverridesBuilder(CloudEventOverrides instance) {
        this(instance,true);
    }

    public CloudEventOverridesBuilder(CloudEventOverrides instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withExtensions(instance.getExtensions()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.internal.pkg.apis.duck.v1.EditableCloudEventOverrides build() {
        EditableCloudEventOverrides buildable = new EditableCloudEventOverrides(fluent.getExtensions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CloudEventOverridesBuilder that = (CloudEventOverridesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
