package io.fabric8.knative.sources.v1beta1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import java.lang.Deprecated;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import java.lang.Boolean;

public class PingSourceSpecFluentImpl<A extends PingSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PingSourceSpecFluent<A> {

    private CloudEventOverridesBuilder ceOverrides;
    private String jsonData;
    private String schedule;
    private DestinationBuilder sink;
    private String timezone;

    public PingSourceSpecFluentImpl() {
    }

    public PingSourceSpecFluentImpl(PingSourceSpec instance) {
        this.withCeOverrides(instance.getCeOverrides()); 
        this.withJsonData(instance.getJsonData()); 
        this.withSchedule(instance.getSchedule()); 
        this.withSink(instance.getSink()); 
        this.withTimezone(instance.getTimezone()); 
    }

    
/**
 * This method has been deprecated, please use method buildCeOverrides instead.
 * @return The buildable object.
 */
@Deprecated public CloudEventOverrides getCeOverrides() {
        return this.ceOverrides!=null?this.ceOverrides.build():null;
    }

    public CloudEventOverrides buildCeOverrides() {
        return this.ceOverrides!=null?this.ceOverrides.build():null;
    }

    public A withCeOverrides(CloudEventOverrides ceOverrides) {
        _visitables.get("ceOverrides").remove(this.ceOverrides);
        if (ceOverrides!=null){ this.ceOverrides= new CloudEventOverridesBuilder(ceOverrides); _visitables.get("ceOverrides").add(this.ceOverrides);} return (A) this;
    }

    public Boolean hasCeOverrides() {
        return this.ceOverrides != null;
    }

    public PingSourceSpecFluent.CeOverridesNested<A> withNewCeOverrides() {
        return new CeOverridesNestedImpl();
    }

    public PingSourceSpecFluent.CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
        return new CeOverridesNestedImpl(item);
    }

    public PingSourceSpecFluent.CeOverridesNested<A> editCeOverrides() {
        return withNewCeOverridesLike(getCeOverrides());
    }

    public PingSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverrides() {
        return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): new CloudEventOverridesBuilder().build());
    }

    public PingSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
        return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): item);
    }

    public String getJsonData() {
        return this.jsonData;
    }

    public A withJsonData(String jsonData) {
        this.jsonData=jsonData; return (A) this;
    }

    public Boolean hasJsonData() {
        return this.jsonData != null;
    }

    public A withNewJsonData(String arg1) {
        return (A)withJsonData(new String(arg1));
    }

    public A withNewJsonData(StringBuilder arg1) {
        return (A)withJsonData(new String(arg1));
    }

    public A withNewJsonData(StringBuffer arg1) {
        return (A)withJsonData(new String(arg1));
    }

    public String getSchedule() {
        return this.schedule;
    }

    public A withSchedule(String schedule) {
        this.schedule=schedule; return (A) this;
    }

    public Boolean hasSchedule() {
        return this.schedule != null;
    }

    public A withNewSchedule(String arg1) {
        return (A)withSchedule(new String(arg1));
    }

    public A withNewSchedule(StringBuilder arg1) {
        return (A)withSchedule(new String(arg1));
    }

    public A withNewSchedule(StringBuffer arg1) {
        return (A)withSchedule(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@Deprecated public Destination getSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public Destination buildSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public A withSink(Destination sink) {
        _visitables.get("sink").remove(this.sink);
        if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} return (A) this;
    }

    public Boolean hasSink() {
        return this.sink != null;
    }

    public PingSourceSpecFluent.SinkNested<A> withNewSink() {
        return new SinkNestedImpl();
    }

    public PingSourceSpecFluent.SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNestedImpl(item);
    }

    public PingSourceSpecFluent.SinkNested<A> editSink() {
        return withNewSinkLike(getSink());
    }

    public PingSourceSpecFluent.SinkNested<A> editOrNewSink() {
        return withNewSinkLike(getSink() != null ? getSink(): new DestinationBuilder().build());
    }

    public PingSourceSpecFluent.SinkNested<A> editOrNewSinkLike(Destination item) {
        return withNewSinkLike(getSink() != null ? getSink(): item);
    }

    public String getTimezone() {
        return this.timezone;
    }

    public A withTimezone(String timezone) {
        this.timezone=timezone; return (A) this;
    }

    public Boolean hasTimezone() {
        return this.timezone != null;
    }

    public A withNewTimezone(String arg1) {
        return (A)withTimezone(new String(arg1));
    }

    public A withNewTimezone(StringBuilder arg1) {
        return (A)withTimezone(new String(arg1));
    }

    public A withNewTimezone(StringBuffer arg1) {
        return (A)withTimezone(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PingSourceSpecFluentImpl that = (PingSourceSpecFluentImpl) o;
        if (ceOverrides != null ? !ceOverrides.equals(that.ceOverrides) :that.ceOverrides != null) return false;
        if (jsonData != null ? !jsonData.equals(that.jsonData) :that.jsonData != null) return false;
        if (schedule != null ? !schedule.equals(that.schedule) :that.schedule != null) return false;
        if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
        if (timezone != null ? !timezone.equals(that.timezone) :that.timezone != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ceOverrides,  jsonData,  schedule,  sink,  timezone,  super.hashCode());
    }

    public class CeOverridesNestedImpl<N> extends CloudEventOverridesFluentImpl<PingSourceSpecFluent.CeOverridesNested<N>> implements PingSourceSpecFluent.CeOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CloudEventOverridesBuilder builder;

            CeOverridesNestedImpl(CloudEventOverrides item) {
                this.builder = new CloudEventOverridesBuilder(this, item);
                        
            }

            CeOverridesNestedImpl() {
                this.builder = new CloudEventOverridesBuilder(this);
                        
            }

            public N and() {
                return (N) PingSourceSpecFluentImpl.this.withCeOverrides(builder.build());
            }

            public N endCeOverrides() {
                return and();
            }
    }


    public class SinkNestedImpl<N> extends DestinationFluentImpl<PingSourceSpecFluent.SinkNested<N>> implements PingSourceSpecFluent.SinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DestinationBuilder builder;

            SinkNestedImpl(Destination item) {
                this.builder = new DestinationBuilder(this, item);
                        
            }

            SinkNestedImpl() {
                this.builder = new DestinationBuilder(this);
                        
            }

            public N and() {
                return (N) PingSourceSpecFluentImpl.this.withSink(builder.build());
            }

            public N endSink() {
                return and();
            }
    }


}
