package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.PodReadinessGate;
import io.fabric8.kubernetes.api.model.HostAlias;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class RevisionSpecFluentImpl<A extends io.fabric8.knative.serving.v1.RevisionSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.serving.v1.RevisionSpecFluent<A>{
  public RevisionSpecFluentImpl() {
  }
  public RevisionSpecFluentImpl(io.fabric8.knative.serving.v1.RevisionSpec instance) {
    this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
    this.withAffinity(instance.getAffinity()); 
    this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken()); 
    this.withContainerConcurrency(instance.getContainerConcurrency()); 
    this.withContainers(instance.getContainers()); 
    this.withDnsConfig(instance.getDnsConfig()); 
    this.withDnsPolicy(instance.getDnsPolicy()); 
    this.withEnableServiceLinks(instance.getEnableServiceLinks()); 
    this.withEphemeralContainers(instance.getEphemeralContainers()); 
    this.withHostAliases(instance.getHostAliases()); 
    this.withHostIPC(instance.getHostIPC()); 
    this.withHostNetwork(instance.getHostNetwork()); 
    this.withHostPID(instance.getHostPID()); 
    this.withHostname(instance.getHostname()); 
    this.withImagePullSecrets(instance.getImagePullSecrets()); 
    this.withInitContainers(instance.getInitContainers()); 
    this.withNodeName(instance.getNodeName()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withOverhead(instance.getOverhead()); 
    this.withPreemptionPolicy(instance.getPreemptionPolicy()); 
    this.withPriority(instance.getPriority()); 
    this.withPriorityClassName(instance.getPriorityClassName()); 
    this.withReadinessGates(instance.getReadinessGates()); 
    this.withRestartPolicy(instance.getRestartPolicy()); 
    this.withRuntimeClassName(instance.getRuntimeClassName()); 
    this.withSchedulerName(instance.getSchedulerName()); 
    this.withSecurityContext(instance.getSecurityContext()); 
    this.withServiceAccount(instance.getServiceAccount()); 
    this.withServiceAccountName(instance.getServiceAccountName()); 
    this.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN()); 
    this.withShareProcessNamespace(instance.getShareProcessNamespace()); 
    this.withSubdomain(instance.getSubdomain()); 
    this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
    this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    this.withTolerations(instance.getTolerations()); 
    this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints()); 
    this.withVolumes(instance.getVolumes()); 
  }
  private java.lang.Long activeDeadlineSeconds;
  private io.fabric8.kubernetes.api.model.Affinity affinity;
  private java.lang.Boolean automountServiceAccountToken;
  private java.lang.Long containerConcurrency;
  private java.util.List<io.fabric8.kubernetes.api.model.ContainerBuilder> containers;
  private io.fabric8.kubernetes.api.model.PodDNSConfig dnsConfig;
  private java.lang.String dnsPolicy;
  private java.lang.Boolean enableServiceLinks;
  private java.util.List<io.fabric8.kubernetes.api.model.EphemeralContainer> ephemeralContainers;
  private java.util.List<io.fabric8.kubernetes.api.model.HostAlias> hostAliases;
  private java.lang.Boolean hostIPC;
  private java.lang.Boolean hostNetwork;
  private java.lang.Boolean hostPID;
  private java.lang.String hostname;
  private java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> imagePullSecrets;
  private java.util.List<io.fabric8.kubernetes.api.model.ContainerBuilder> initContainers;
  private java.lang.String nodeName;
  private java.util.Map<java.lang.String,java.lang.String> nodeSelector;
  private java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> overhead;
  private java.lang.String preemptionPolicy;
  private java.lang.Integer priority;
  private java.lang.String priorityClassName;
  private java.util.List<io.fabric8.kubernetes.api.model.PodReadinessGate> readinessGates;
  private java.lang.String restartPolicy;
  private java.lang.String runtimeClassName;
  private java.lang.String schedulerName;
  private io.fabric8.kubernetes.api.model.PodSecurityContext securityContext;
  private java.lang.String serviceAccount;
  private java.lang.String serviceAccountName;
  private java.lang.Boolean setHostnameAsFQDN;
  private java.lang.Boolean shareProcessNamespace;
  private java.lang.String subdomain;
  private java.lang.Long terminationGracePeriodSeconds;
  private java.lang.Long timeoutSeconds;
  private java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations;
  private java.util.List<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> topologySpreadConstraints;
  private java.util.List<io.fabric8.kubernetes.api.model.VolumeBuilder> volumes;
  public java.lang.Long getActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds;
  }
  public A withActiveDeadlineSeconds(java.lang.Long activeDeadlineSeconds) {
    this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
  }
  public java.lang.Boolean hasActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds != null;
  }
  public io.fabric8.kubernetes.api.model.Affinity getAffinity() {
    return this.affinity;
  }
  public A withAffinity(io.fabric8.kubernetes.api.model.Affinity affinity) {
    this.affinity=affinity; return (A) this;
  }
  public java.lang.Boolean hasAffinity() {
    return this.affinity != null;
  }
  public java.lang.Boolean getAutomountServiceAccountToken() {
    return this.automountServiceAccountToken;
  }
  public A withAutomountServiceAccountToken(java.lang.Boolean automountServiceAccountToken) {
    this.automountServiceAccountToken=automountServiceAccountToken; return (A) this;
  }
  public java.lang.Boolean hasAutomountServiceAccountToken() {
    return this.automountServiceAccountToken != null;
  }
  public java.lang.Long getContainerConcurrency() {
    return this.containerConcurrency;
  }
  public A withContainerConcurrency(java.lang.Long containerConcurrency) {
    this.containerConcurrency=containerConcurrency; return (A) this;
  }
  public java.lang.Boolean hasContainerConcurrency() {
    return this.containerConcurrency != null;
  }
  public A addToContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
    if (this.containers == null) {this.containers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("containers").add(index >= 0 ? index : _visitables.get("containers").size(), builder);this.containers.add(index >= 0 ? index : containers.size(), builder); return (A)this;
  }
  public A setToContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
    if (this.containers == null) {this.containers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("containers").size()) { _visitables.get("containers").add(builder); } else { _visitables.get("containers").set(index, builder);}
    if (index < 0 || index >= containers.size()) { containers.add(builder); } else { containers.set(index, builder);}
     return (A)this;
  }
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.containers == null) {this.containers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A addAllToContainers(java.util.Collection<io.fabric8.kubernetes.api.model.Container> items) {
    if (this.containers == null) {this.containers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainers(java.util.Collection<io.fabric8.kubernetes.api.model.Container> items) {
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainers(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    if (containers == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ContainerBuilder> each = containers.iterator();
    final List visitables = _visitables.get("containers");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.Container> getContainers() {
    return build(containers);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Container> buildContainers() {
    return build(containers);
  }
  public io.fabric8.kubernetes.api.model.Container buildContainer(java.lang.Integer index) {
    return this.containers.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.Container buildFirstContainer() {
    return this.containers.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.Container buildLastContainer() {
    return this.containers.get(containers.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.Container buildMatchingContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerBuilder item: containers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerBuilder item: containers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainers(java.util.List<io.fabric8.kubernetes.api.model.Container> containers) {
    if (this.containers != null) { _visitables.get("containers").removeAll(this.containers);}
    if (containers != null) {this.containers = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.Container item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
  }
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers) {
    if (this.containers != null) {this.containers.clear();}
    if (containers != null) {for (io.fabric8.kubernetes.api.model.Container item :containers){ this.addToContainers(item);}} return (A) this;
  }
  public java.lang.Boolean hasContainers() {
    return containers != null && !containers.isEmpty();
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.ContainersNested<A> addNewContainer() {
    return new io.fabric8.knative.serving.v1.RevisionSpecFluentImpl.ContainersNestedImpl();
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.ContainersNested<A> addNewContainerLike(io.fabric8.kubernetes.api.model.Container item) {
    return new io.fabric8.knative.serving.v1.RevisionSpecFluentImpl.ContainersNestedImpl(-1, item);
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.ContainersNested<A> setNewContainerLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
    return new io.fabric8.knative.serving.v1.RevisionSpecFluentImpl.ContainersNestedImpl(index, item);
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.ContainersNested<A> editContainer(java.lang.Integer index) {
    if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.ContainersNested<A> editFirstContainer() {
    if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
    return setNewContainerLike(0, buildContainer(0));
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.ContainersNested<A> editLastContainer() {
    int index = containers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.ContainersNested<A> editMatchingContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containers.size();i++) { 
    if (predicate.test(containers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public io.fabric8.kubernetes.api.model.PodDNSConfig getDnsConfig() {
    return this.dnsConfig;
  }
  public A withDnsConfig(io.fabric8.kubernetes.api.model.PodDNSConfig dnsConfig) {
    this.dnsConfig=dnsConfig; return (A) this;
  }
  public java.lang.Boolean hasDnsConfig() {
    return this.dnsConfig != null;
  }
  public java.lang.String getDnsPolicy() {
    return this.dnsPolicy;
  }
  public A withDnsPolicy(java.lang.String dnsPolicy) {
    this.dnsPolicy=dnsPolicy; return (A) this;
  }
  public java.lang.Boolean hasDnsPolicy() {
    return this.dnsPolicy != null;
  }
  
  /**
   * Method is deprecated. use withDnsPolicy instead.
   */
  @java.lang.Deprecated
  public A withNewDnsPolicy(java.lang.String arg0) {
    return (A)withDnsPolicy(new String(arg0));
  }
  public java.lang.Boolean getEnableServiceLinks() {
    return this.enableServiceLinks;
  }
  public A withEnableServiceLinks(java.lang.Boolean enableServiceLinks) {
    this.enableServiceLinks=enableServiceLinks; return (A) this;
  }
  public java.lang.Boolean hasEnableServiceLinks() {
    return this.enableServiceLinks != null;
  }
  public A addToEphemeralContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.EphemeralContainer item) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EphemeralContainer>();}
    this.ephemeralContainers.add(index, item);
    return (A)this;
  }
  public A setToEphemeralContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.EphemeralContainer item) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EphemeralContainer>();}
    this.ephemeralContainers.set(index, item); return (A)this;
  }
  public A addToEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EphemeralContainer>();}
    for (io.fabric8.kubernetes.api.model.EphemeralContainer item : items) {this.ephemeralContainers.add(item);} return (A)this;
  }
  public A addAllToEphemeralContainers(java.util.Collection<io.fabric8.kubernetes.api.model.EphemeralContainer> items) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EphemeralContainer>();}
    for (io.fabric8.kubernetes.api.model.EphemeralContainer item : items) {this.ephemeralContainers.add(item);} return (A)this;
  }
  public A removeFromEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items) {
    for (io.fabric8.kubernetes.api.model.EphemeralContainer item : items) {if (this.ephemeralContainers!= null){ this.ephemeralContainers.remove(item);}} return (A)this;
  }
  public A removeAllFromEphemeralContainers(java.util.Collection<io.fabric8.kubernetes.api.model.EphemeralContainer> items) {
    for (io.fabric8.kubernetes.api.model.EphemeralContainer item : items) {if (this.ephemeralContainers!= null){ this.ephemeralContainers.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.EphemeralContainer> getEphemeralContainers() {
    return this.ephemeralContainers;
  }
  public io.fabric8.kubernetes.api.model.EphemeralContainer getEphemeralContainer(java.lang.Integer index) {
    return this.ephemeralContainers.get(index);
  }
  public io.fabric8.kubernetes.api.model.EphemeralContainer getFirstEphemeralContainer() {
    return this.ephemeralContainers.get(0);
  }
  public io.fabric8.kubernetes.api.model.EphemeralContainer getLastEphemeralContainer() {
    return this.ephemeralContainers.get(ephemeralContainers.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.EphemeralContainer getMatchingEphemeralContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EphemeralContainer> predicate) {
    for (io.fabric8.kubernetes.api.model.EphemeralContainer item: ephemeralContainers) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingEphemeralContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EphemeralContainer> predicate) {
    for (io.fabric8.kubernetes.api.model.EphemeralContainer item: ephemeralContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEphemeralContainers(java.util.List<io.fabric8.kubernetes.api.model.EphemeralContainer> ephemeralContainers) {
    if (ephemeralContainers != null) {this.ephemeralContainers = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.EphemeralContainer item : ephemeralContainers){this.addToEphemeralContainers(item);}} else { this.ephemeralContainers = null;} return (A) this;
  }
  public A withEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... ephemeralContainers) {
    if (this.ephemeralContainers != null) {this.ephemeralContainers.clear();}
    if (ephemeralContainers != null) {for (io.fabric8.kubernetes.api.model.EphemeralContainer item :ephemeralContainers){ this.addToEphemeralContainers(item);}} return (A) this;
  }
  public java.lang.Boolean hasEphemeralContainers() {
    return ephemeralContainers != null && !ephemeralContainers.isEmpty();
  }
  public A addToHostAliases(java.lang.Integer index,io.fabric8.kubernetes.api.model.HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HostAlias>();}
    this.hostAliases.add(index, item);
    return (A)this;
  }
  public A setToHostAliases(java.lang.Integer index,io.fabric8.kubernetes.api.model.HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HostAlias>();}
    this.hostAliases.set(index, item); return (A)this;
  }
  public A addToHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items) {
    if (this.hostAliases == null) {this.hostAliases = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HostAlias>();}
    for (io.fabric8.kubernetes.api.model.HostAlias item : items) {this.hostAliases.add(item);} return (A)this;
  }
  public A addAllToHostAliases(java.util.Collection<io.fabric8.kubernetes.api.model.HostAlias> items) {
    if (this.hostAliases == null) {this.hostAliases = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HostAlias>();}
    for (io.fabric8.kubernetes.api.model.HostAlias item : items) {this.hostAliases.add(item);} return (A)this;
  }
  public A removeFromHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items) {
    for (io.fabric8.kubernetes.api.model.HostAlias item : items) {if (this.hostAliases!= null){ this.hostAliases.remove(item);}} return (A)this;
  }
  public A removeAllFromHostAliases(java.util.Collection<io.fabric8.kubernetes.api.model.HostAlias> items) {
    for (io.fabric8.kubernetes.api.model.HostAlias item : items) {if (this.hostAliases!= null){ this.hostAliases.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.HostAlias> getHostAliases() {
    return this.hostAliases;
  }
  public io.fabric8.kubernetes.api.model.HostAlias getHostAlias(java.lang.Integer index) {
    return this.hostAliases.get(index);
  }
  public io.fabric8.kubernetes.api.model.HostAlias getFirstHostAlias() {
    return this.hostAliases.get(0);
  }
  public io.fabric8.kubernetes.api.model.HostAlias getLastHostAlias() {
    return this.hostAliases.get(hostAliases.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.HostAlias getMatchingHostAlias(java.util.function.Predicate<io.fabric8.kubernetes.api.model.HostAlias> predicate) {
    for (io.fabric8.kubernetes.api.model.HostAlias item: hostAliases) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingHostAlias(java.util.function.Predicate<io.fabric8.kubernetes.api.model.HostAlias> predicate) {
    for (io.fabric8.kubernetes.api.model.HostAlias item: hostAliases) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHostAliases(java.util.List<io.fabric8.kubernetes.api.model.HostAlias> hostAliases) {
    if (hostAliases != null) {this.hostAliases = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.HostAlias item : hostAliases){this.addToHostAliases(item);}} else { this.hostAliases = null;} return (A) this;
  }
  public A withHostAliases(io.fabric8.kubernetes.api.model.HostAlias... hostAliases) {
    if (this.hostAliases != null) {this.hostAliases.clear();}
    if (hostAliases != null) {for (io.fabric8.kubernetes.api.model.HostAlias item :hostAliases){ this.addToHostAliases(item);}} return (A) this;
  }
  public java.lang.Boolean hasHostAliases() {
    return hostAliases != null && !hostAliases.isEmpty();
  }
  public java.lang.Boolean getHostIPC() {
    return this.hostIPC;
  }
  public A withHostIPC(java.lang.Boolean hostIPC) {
    this.hostIPC=hostIPC; return (A) this;
  }
  public java.lang.Boolean hasHostIPC() {
    return this.hostIPC != null;
  }
  public java.lang.Boolean getHostNetwork() {
    return this.hostNetwork;
  }
  public A withHostNetwork(java.lang.Boolean hostNetwork) {
    this.hostNetwork=hostNetwork; return (A) this;
  }
  public java.lang.Boolean hasHostNetwork() {
    return this.hostNetwork != null;
  }
  public java.lang.Boolean getHostPID() {
    return this.hostPID;
  }
  public A withHostPID(java.lang.Boolean hostPID) {
    this.hostPID=hostPID; return (A) this;
  }
  public java.lang.Boolean hasHostPID() {
    return this.hostPID != null;
  }
  public java.lang.String getHostname() {
    return this.hostname;
  }
  public A withHostname(java.lang.String hostname) {
    this.hostname=hostname; return (A) this;
  }
  public java.lang.Boolean hasHostname() {
    return this.hostname != null;
  }
  
  /**
   * Method is deprecated. use withHostname instead.
   */
  @java.lang.Deprecated
  public A withNewHostname(java.lang.String arg0) {
    return (A)withHostname(new String(arg0));
  }
  public A addToImagePullSecrets(java.lang.Integer index,io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>();}
    this.imagePullSecrets.add(index, item);
    return (A)this;
  }
  public A setToImagePullSecrets(java.lang.Integer index,io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>();}
    this.imagePullSecrets.set(index, item); return (A)this;
  }
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>();}
    for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {this.imagePullSecrets.add(item);} return (A)this;
  }
  public A addAllToImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>();}
    for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {this.imagePullSecrets.add(item);} return (A)this;
  }
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {if (this.imagePullSecrets!= null){ this.imagePullSecrets.remove(item);}} return (A)this;
  }
  public A removeAllFromImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items) {
    for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {if (this.imagePullSecrets!= null){ this.imagePullSecrets.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> getImagePullSecrets() {
    return this.imagePullSecrets;
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference getImagePullSecret(java.lang.Integer index) {
    return this.imagePullSecrets.get(index);
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference getFirstImagePullSecret() {
    return this.imagePullSecrets.get(0);
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference getLastImagePullSecret() {
    return this.imagePullSecrets.get(imagePullSecrets.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference getMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReference> predicate) {
    for (io.fabric8.kubernetes.api.model.LocalObjectReference item: imagePullSecrets) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReference> predicate) {
    for (io.fabric8.kubernetes.api.model.LocalObjectReference item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImagePullSecrets(java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> imagePullSecrets) {
    if (imagePullSecrets != null) {this.imagePullSecrets = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
  }
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets) {
    if (this.imagePullSecrets != null) {this.imagePullSecrets.clear();}
    if (imagePullSecrets != null) {for (io.fabric8.kubernetes.api.model.LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
  }
  public java.lang.Boolean hasImagePullSecrets() {
    return imagePullSecrets != null && !imagePullSecrets.isEmpty();
  }
  public A addNewImagePullSecret(java.lang.String name) {
    return (A)addToImagePullSecrets(new LocalObjectReference(name));
  }
  public A addToInitContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
    if (this.initContainers == null) {this.initContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("initContainers").add(index >= 0 ? index : _visitables.get("initContainers").size(), builder);this.initContainers.add(index >= 0 ? index : initContainers.size(), builder); return (A)this;
  }
  public A setToInitContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
    if (this.initContainers == null) {this.initContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("initContainers").size()) { _visitables.get("initContainers").add(builder); } else { _visitables.get("initContainers").set(index, builder);}
    if (index < 0 || index >= initContainers.size()) { initContainers.add(builder); } else { initContainers.set(index, builder);}
     return (A)this;
  }
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.initContainers == null) {this.initContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A addAllToInitContainers(java.util.Collection<io.fabric8.kubernetes.api.model.Container> items) {
    if (this.initContainers == null) {this.initContainers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerBuilder>();}
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromInitContainers(java.util.Collection<io.fabric8.kubernetes.api.model.Container> items) {
    for (io.fabric8.kubernetes.api.model.Container item : items) {io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInitContainers(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    if (initContainers == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ContainerBuilder> each = initContainers.iterator();
    final List visitables = _visitables.get("initContainers");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.Container> getInitContainers() {
    return build(initContainers);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Container> buildInitContainers() {
    return build(initContainers);
  }
  public io.fabric8.kubernetes.api.model.Container buildInitContainer(java.lang.Integer index) {
    return this.initContainers.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.Container buildFirstInitContainer() {
    return this.initContainers.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.Container buildLastInitContainer() {
    return this.initContainers.get(initContainers.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.Container buildMatchingInitContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerBuilder item: initContainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingInitContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerBuilder item: initContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInitContainers(java.util.List<io.fabric8.kubernetes.api.model.Container> initContainers) {
    if (this.initContainers != null) { _visitables.get("initContainers").removeAll(this.initContainers);}
    if (initContainers != null) {this.initContainers = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.Container item : initContainers){this.addToInitContainers(item);}} else { this.initContainers = null;} return (A) this;
  }
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers) {
    if (this.initContainers != null) {this.initContainers.clear();}
    if (initContainers != null) {for (io.fabric8.kubernetes.api.model.Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
  }
  public java.lang.Boolean hasInitContainers() {
    return initContainers != null && !initContainers.isEmpty();
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.InitContainersNested<A> addNewInitContainer() {
    return new io.fabric8.knative.serving.v1.RevisionSpecFluentImpl.InitContainersNestedImpl();
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.InitContainersNested<A> addNewInitContainerLike(io.fabric8.kubernetes.api.model.Container item) {
    return new io.fabric8.knative.serving.v1.RevisionSpecFluentImpl.InitContainersNestedImpl(-1, item);
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.InitContainersNested<A> setNewInitContainerLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
    return new io.fabric8.knative.serving.v1.RevisionSpecFluentImpl.InitContainersNestedImpl(index, item);
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.InitContainersNested<A> editInitContainer(java.lang.Integer index) {
    if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.InitContainersNested<A> editFirstInitContainer() {
    if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
    return setNewInitContainerLike(0, buildInitContainer(0));
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.InitContainersNested<A> editLastInitContainer() {
    int index = initContainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.InitContainersNested<A> editMatchingInitContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainers.size();i++) { 
    if (predicate.test(initContainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public java.lang.String getNodeName() {
    return this.nodeName;
  }
  public A withNodeName(java.lang.String nodeName) {
    this.nodeName=nodeName; return (A) this;
  }
  public java.lang.Boolean hasNodeName() {
    return this.nodeName != null;
  }
  
  /**
   * Method is deprecated. use withNodeName instead.
   */
  @java.lang.Deprecated
  public A withNewNodeName(java.lang.String arg0) {
    return (A)withNodeName(new String(arg0));
  }
  public A addToNodeSelector(java.lang.String key,java.lang.String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new java.util.LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(java.lang.String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(java.util.Map<java.lang.String,java.lang.String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new java.util.LinkedHashMap(nodeSelector);} return (A) this;
  }
  public java.lang.Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public A addToOverhead(java.lang.String key,io.fabric8.kubernetes.api.model.Quantity value) {
    if(this.overhead == null && key != null && value != null) { this.overhead = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.overhead.put(key, value);} return (A)this;
  }
  public A addToOverhead(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.overhead == null && map != null) { this.overhead = new java.util.LinkedHashMap(); }
    if(map != null) { this.overhead.putAll(map);} return (A)this;
  }
  public A removeFromOverhead(java.lang.String key) {
    if(this.overhead == null) { return (A) this; }
    if(key != null && this.overhead != null) {this.overhead.remove(key);} return (A)this;
  }
  public A removeFromOverhead(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.overhead == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.overhead != null){this.overhead.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getOverhead() {
    return this.overhead;
  }
  public <K,V>A withOverhead(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> overhead) {
    if (overhead == null) { this.overhead =  null;} else {this.overhead = new java.util.LinkedHashMap(overhead);} return (A) this;
  }
  public java.lang.Boolean hasOverhead() {
    return this.overhead != null;
  }
  public java.lang.String getPreemptionPolicy() {
    return this.preemptionPolicy;
  }
  public A withPreemptionPolicy(java.lang.String preemptionPolicy) {
    this.preemptionPolicy=preemptionPolicy; return (A) this;
  }
  public java.lang.Boolean hasPreemptionPolicy() {
    return this.preemptionPolicy != null;
  }
  
  /**
   * Method is deprecated. use withPreemptionPolicy instead.
   */
  @java.lang.Deprecated
  public A withNewPreemptionPolicy(java.lang.String arg0) {
    return (A)withPreemptionPolicy(new String(arg0));
  }
  public java.lang.Integer getPriority() {
    return this.priority;
  }
  public A withPriority(java.lang.Integer priority) {
    this.priority=priority; return (A) this;
  }
  public java.lang.Boolean hasPriority() {
    return this.priority != null;
  }
  public java.lang.String getPriorityClassName() {
    return this.priorityClassName;
  }
  public A withPriorityClassName(java.lang.String priorityClassName) {
    this.priorityClassName=priorityClassName; return (A) this;
  }
  public java.lang.Boolean hasPriorityClassName() {
    return this.priorityClassName != null;
  }
  
  /**
   * Method is deprecated. use withPriorityClassName instead.
   */
  @java.lang.Deprecated
  public A withNewPriorityClassName(java.lang.String arg0) {
    return (A)withPriorityClassName(new String(arg0));
  }
  public A addToReadinessGates(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodReadinessGate item) {
    if (this.readinessGates == null) {this.readinessGates = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodReadinessGate>();}
    this.readinessGates.add(index, item);
    return (A)this;
  }
  public A setToReadinessGates(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodReadinessGate item) {
    if (this.readinessGates == null) {this.readinessGates = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodReadinessGate>();}
    this.readinessGates.set(index, item); return (A)this;
  }
  public A addToReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... items) {
    if (this.readinessGates == null) {this.readinessGates = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodReadinessGate>();}
    for (io.fabric8.kubernetes.api.model.PodReadinessGate item : items) {this.readinessGates.add(item);} return (A)this;
  }
  public A addAllToReadinessGates(java.util.Collection<io.fabric8.kubernetes.api.model.PodReadinessGate> items) {
    if (this.readinessGates == null) {this.readinessGates = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodReadinessGate>();}
    for (io.fabric8.kubernetes.api.model.PodReadinessGate item : items) {this.readinessGates.add(item);} return (A)this;
  }
  public A removeFromReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... items) {
    for (io.fabric8.kubernetes.api.model.PodReadinessGate item : items) {if (this.readinessGates!= null){ this.readinessGates.remove(item);}} return (A)this;
  }
  public A removeAllFromReadinessGates(java.util.Collection<io.fabric8.kubernetes.api.model.PodReadinessGate> items) {
    for (io.fabric8.kubernetes.api.model.PodReadinessGate item : items) {if (this.readinessGates!= null){ this.readinessGates.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.PodReadinessGate> getReadinessGates() {
    return this.readinessGates;
  }
  public io.fabric8.kubernetes.api.model.PodReadinessGate getReadinessGate(java.lang.Integer index) {
    return this.readinessGates.get(index);
  }
  public io.fabric8.kubernetes.api.model.PodReadinessGate getFirstReadinessGate() {
    return this.readinessGates.get(0);
  }
  public io.fabric8.kubernetes.api.model.PodReadinessGate getLastReadinessGate() {
    return this.readinessGates.get(readinessGates.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.PodReadinessGate getMatchingReadinessGate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodReadinessGate> predicate) {
    for (io.fabric8.kubernetes.api.model.PodReadinessGate item: readinessGates) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingReadinessGate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodReadinessGate> predicate) {
    for (io.fabric8.kubernetes.api.model.PodReadinessGate item: readinessGates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withReadinessGates(java.util.List<io.fabric8.kubernetes.api.model.PodReadinessGate> readinessGates) {
    if (readinessGates != null) {this.readinessGates = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.PodReadinessGate item : readinessGates){this.addToReadinessGates(item);}} else { this.readinessGates = null;} return (A) this;
  }
  public A withReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... readinessGates) {
    if (this.readinessGates != null) {this.readinessGates.clear();}
    if (readinessGates != null) {for (io.fabric8.kubernetes.api.model.PodReadinessGate item :readinessGates){ this.addToReadinessGates(item);}} return (A) this;
  }
  public java.lang.Boolean hasReadinessGates() {
    return readinessGates != null && !readinessGates.isEmpty();
  }
  public A addNewReadinessGate(java.lang.String conditionType) {
    return (A)addToReadinessGates(new PodReadinessGate(conditionType));
  }
  public java.lang.String getRestartPolicy() {
    return this.restartPolicy;
  }
  public A withRestartPolicy(java.lang.String restartPolicy) {
    this.restartPolicy=restartPolicy; return (A) this;
  }
  public java.lang.Boolean hasRestartPolicy() {
    return this.restartPolicy != null;
  }
  
  /**
   * Method is deprecated. use withRestartPolicy instead.
   */
  @java.lang.Deprecated
  public A withNewRestartPolicy(java.lang.String arg0) {
    return (A)withRestartPolicy(new String(arg0));
  }
  public java.lang.String getRuntimeClassName() {
    return this.runtimeClassName;
  }
  public A withRuntimeClassName(java.lang.String runtimeClassName) {
    this.runtimeClassName=runtimeClassName; return (A) this;
  }
  public java.lang.Boolean hasRuntimeClassName() {
    return this.runtimeClassName != null;
  }
  
  /**
   * Method is deprecated. use withRuntimeClassName instead.
   */
  @java.lang.Deprecated
  public A withNewRuntimeClassName(java.lang.String arg0) {
    return (A)withRuntimeClassName(new String(arg0));
  }
  public java.lang.String getSchedulerName() {
    return this.schedulerName;
  }
  public A withSchedulerName(java.lang.String schedulerName) {
    this.schedulerName=schedulerName; return (A) this;
  }
  public java.lang.Boolean hasSchedulerName() {
    return this.schedulerName != null;
  }
  
  /**
   * Method is deprecated. use withSchedulerName instead.
   */
  @java.lang.Deprecated
  public A withNewSchedulerName(java.lang.String arg0) {
    return (A)withSchedulerName(new String(arg0));
  }
  public io.fabric8.kubernetes.api.model.PodSecurityContext getSecurityContext() {
    return this.securityContext;
  }
  public A withSecurityContext(io.fabric8.kubernetes.api.model.PodSecurityContext securityContext) {
    this.securityContext=securityContext; return (A) this;
  }
  public java.lang.Boolean hasSecurityContext() {
    return this.securityContext != null;
  }
  public java.lang.String getServiceAccount() {
    return this.serviceAccount;
  }
  public A withServiceAccount(java.lang.String serviceAccount) {
    this.serviceAccount=serviceAccount; return (A) this;
  }
  public java.lang.Boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  
  /**
   * Method is deprecated. use withServiceAccount instead.
   */
  @java.lang.Deprecated
  public A withNewServiceAccount(java.lang.String arg0) {
    return (A)withServiceAccount(new String(arg0));
  }
  public java.lang.String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(java.lang.String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public java.lang.Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  /**
   * Method is deprecated. use withServiceAccountName instead.
   */
  @java.lang.Deprecated
  public A withNewServiceAccountName(java.lang.String arg0) {
    return (A)withServiceAccountName(new String(arg0));
  }
  public java.lang.Boolean getSetHostnameAsFQDN() {
    return this.setHostnameAsFQDN;
  }
  public A withSetHostnameAsFQDN(java.lang.Boolean setHostnameAsFQDN) {
    this.setHostnameAsFQDN=setHostnameAsFQDN; return (A) this;
  }
  public java.lang.Boolean hasSetHostnameAsFQDN() {
    return this.setHostnameAsFQDN != null;
  }
  public java.lang.Boolean getShareProcessNamespace() {
    return this.shareProcessNamespace;
  }
  public A withShareProcessNamespace(java.lang.Boolean shareProcessNamespace) {
    this.shareProcessNamespace=shareProcessNamespace; return (A) this;
  }
  public java.lang.Boolean hasShareProcessNamespace() {
    return this.shareProcessNamespace != null;
  }
  public java.lang.String getSubdomain() {
    return this.subdomain;
  }
  public A withSubdomain(java.lang.String subdomain) {
    this.subdomain=subdomain; return (A) this;
  }
  public java.lang.Boolean hasSubdomain() {
    return this.subdomain != null;
  }
  
  /**
   * Method is deprecated. use withSubdomain instead.
   */
  @java.lang.Deprecated
  public A withNewSubdomain(java.lang.String arg0) {
    return (A)withSubdomain(new String(arg0));
  }
  public java.lang.Long getTerminationGracePeriodSeconds() {
    return this.terminationGracePeriodSeconds;
  }
  public A withTerminationGracePeriodSeconds(java.lang.Long terminationGracePeriodSeconds) {
    this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (A) this;
  }
  public java.lang.Boolean hasTerminationGracePeriodSeconds() {
    return this.terminationGracePeriodSeconds != null;
  }
  public java.lang.Long getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  public A withTimeoutSeconds(java.lang.Long timeoutSeconds) {
    this.timeoutSeconds=timeoutSeconds; return (A) this;
  }
  public java.lang.Boolean hasTimeoutSeconds() {
    return this.timeoutSeconds != null;
  }
  public A addToTolerations(java.lang.Integer index,io.fabric8.kubernetes.api.model.Toleration item) {
    if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  public A setToTolerations(java.lang.Integer index,io.fabric8.kubernetes.api.model.Toleration item) {
    if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
    for (io.fabric8.kubernetes.api.model.Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A addAllToTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
    for (io.fabric8.kubernetes.api.model.Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    for (io.fabric8.kubernetes.api.model.Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public A removeAllFromTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items) {
    for (io.fabric8.kubernetes.api.model.Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Toleration> getTolerations() {
    return this.tolerations;
  }
  public io.fabric8.kubernetes.api.model.Toleration getToleration(java.lang.Integer index) {
    return this.tolerations.get(index);
  }
  public io.fabric8.kubernetes.api.model.Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  public io.fabric8.kubernetes.api.model.Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.Toleration getMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate) {
    for (io.fabric8.kubernetes.api.model.Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate) {
    for (io.fabric8.kubernetes.api.model.Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations) {
    if (tolerations != null) {this.tolerations = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear();}
    if (tolerations != null) {for (io.fabric8.kubernetes.api.model.Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public java.lang.Boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(java.lang.String effect,java.lang.String key,java.lang.String operator,java.lang.Long tolerationSeconds,java.lang.String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public A addToTopologySpreadConstraints(java.lang.Integer index,io.fabric8.kubernetes.api.model.TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>();}
    this.topologySpreadConstraints.add(index, item);
    return (A)this;
  }
  public A setToTopologySpreadConstraints(java.lang.Integer index,io.fabric8.kubernetes.api.model.TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>();}
    this.topologySpreadConstraints.set(index, item); return (A)this;
  }
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>();}
    for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A addAllToTopologySpreadConstraints(java.util.Collection<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>();}
    for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public A removeAllFromTopologySpreadConstraints(java.util.Collection<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> items) {
    for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> getTopologySpreadConstraints() {
    return this.topologySpreadConstraints;
  }
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getTopologySpreadConstraint(java.lang.Integer index) {
    return this.topologySpreadConstraints.get(index);
  }
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getFirstTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(0);
  }
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getLastTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(topologySpreadConstraints.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getMatchingTopologySpreadConstraint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> predicate) {
    for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingTopologySpreadConstraint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> predicate) {
    for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTopologySpreadConstraints(java.util.List<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> topologySpreadConstraints) {
    if (topologySpreadConstraints != null) {this.topologySpreadConstraints = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : topologySpreadConstraints){this.addToTopologySpreadConstraints(item);}} else { this.topologySpreadConstraints = null;} return (A) this;
  }
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints) {
    if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.clear();}
    if (topologySpreadConstraints != null) {for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item :topologySpreadConstraints){ this.addToTopologySpreadConstraints(item);}} return (A) this;
  }
  public java.lang.Boolean hasTopologySpreadConstraints() {
    return topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty();
  }
  public A addToVolumes(java.lang.Integer index,io.fabric8.kubernetes.api.model.Volume item) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeBuilder>();}
    io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
  }
  public A setToVolumes(java.lang.Integer index,io.fabric8.kubernetes.api.model.Volume item) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeBuilder>();}
    io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);
    if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
    if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
     return (A)this;
  }
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeBuilder>();}
    for (io.fabric8.kubernetes.api.model.Volume item : items) {io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A addAllToVolumes(java.util.Collection<io.fabric8.kubernetes.api.model.Volume> items) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeBuilder>();}
    for (io.fabric8.kubernetes.api.model.Volume item : items) {io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    for (io.fabric8.kubernetes.api.model.Volume item : items) {io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumes(java.util.Collection<io.fabric8.kubernetes.api.model.Volume> items) {
    for (io.fabric8.kubernetes.api.model.Volume item : items) {io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumes(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.VolumeBuilder> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.VolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.Volume> getVolumes() {
    return build(volumes);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Volume> buildVolumes() {
    return build(volumes);
  }
  public io.fabric8.kubernetes.api.model.Volume buildVolume(java.lang.Integer index) {
    return this.volumes.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.Volume buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.Volume buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.Volume buildMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.VolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.VolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(java.util.List<io.fabric8.kubernetes.api.model.Volume> volumes) {
    if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
    if (volumes != null) {this.volumes = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes) {
    if (this.volumes != null) {this.volumes.clear();}
    if (volumes != null) {for (io.fabric8.kubernetes.api.model.Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public java.lang.Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.VolumesNested<A> addNewVolume() {
    return new io.fabric8.knative.serving.v1.RevisionSpecFluentImpl.VolumesNestedImpl();
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.VolumesNested<A> addNewVolumeLike(io.fabric8.kubernetes.api.model.Volume item) {
    return new io.fabric8.knative.serving.v1.RevisionSpecFluentImpl.VolumesNestedImpl(-1, item);
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.VolumesNested<A> setNewVolumeLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Volume item) {
    return new io.fabric8.knative.serving.v1.RevisionSpecFluentImpl.VolumesNestedImpl(index, item);
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.VolumesNested<A> editVolume(java.lang.Integer index) {
    if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.VolumesNested<A> editFirstVolume() {
    if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
    return setNewVolumeLike(0, buildVolume(0));
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.VolumesNested<A> editLastVolume() {
    int index = volumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public io.fabric8.knative.serving.v1.RevisionSpecFluent.VolumesNested<A> editMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumes.size();i++) { 
    if (predicate.test(volumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RevisionSpecFluentImpl that = (RevisionSpecFluentImpl) o;
    if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
    if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
    if (automountServiceAccountToken != null ? !automountServiceAccountToken.equals(that.automountServiceAccountToken) :that.automountServiceAccountToken != null) return false;
    if (containerConcurrency != null ? !containerConcurrency.equals(that.containerConcurrency) :that.containerConcurrency != null) return false;
    if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
    if (dnsConfig != null ? !dnsConfig.equals(that.dnsConfig) :that.dnsConfig != null) return false;
    if (dnsPolicy != null ? !dnsPolicy.equals(that.dnsPolicy) :that.dnsPolicy != null) return false;
    if (enableServiceLinks != null ? !enableServiceLinks.equals(that.enableServiceLinks) :that.enableServiceLinks != null) return false;
    if (ephemeralContainers != null ? !ephemeralContainers.equals(that.ephemeralContainers) :that.ephemeralContainers != null) return false;
    if (hostAliases != null ? !hostAliases.equals(that.hostAliases) :that.hostAliases != null) return false;
    if (hostIPC != null ? !hostIPC.equals(that.hostIPC) :that.hostIPC != null) return false;
    if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
    if (hostPID != null ? !hostPID.equals(that.hostPID) :that.hostPID != null) return false;
    if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
    if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
    if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
    if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
    if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
    if (overhead != null ? !overhead.equals(that.overhead) :that.overhead != null) return false;
    if (preemptionPolicy != null ? !preemptionPolicy.equals(that.preemptionPolicy) :that.preemptionPolicy != null) return false;
    if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
    if (priorityClassName != null ? !priorityClassName.equals(that.priorityClassName) :that.priorityClassName != null) return false;
    if (readinessGates != null ? !readinessGates.equals(that.readinessGates) :that.readinessGates != null) return false;
    if (restartPolicy != null ? !restartPolicy.equals(that.restartPolicy) :that.restartPolicy != null) return false;
    if (runtimeClassName != null ? !runtimeClassName.equals(that.runtimeClassName) :that.runtimeClassName != null) return false;
    if (schedulerName != null ? !schedulerName.equals(that.schedulerName) :that.schedulerName != null) return false;
    if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
    if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
    if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
    if (setHostnameAsFQDN != null ? !setHostnameAsFQDN.equals(that.setHostnameAsFQDN) :that.setHostnameAsFQDN != null) return false;
    if (shareProcessNamespace != null ? !shareProcessNamespace.equals(that.shareProcessNamespace) :that.shareProcessNamespace != null) return false;
    if (subdomain != null ? !subdomain.equals(that.subdomain) :that.subdomain != null) return false;
    if (terminationGracePeriodSeconds != null ? !terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) :that.terminationGracePeriodSeconds != null) return false;
    if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
    if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
    if (topologySpreadConstraints != null ? !topologySpreadConstraints.equals(that.topologySpreadConstraints) :that.topologySpreadConstraints != null) return false;
    if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(activeDeadlineSeconds,  affinity,  automountServiceAccountToken,  containerConcurrency,  containers,  dnsConfig,  dnsPolicy,  enableServiceLinks,  ephemeralContainers,  hostAliases,  hostIPC,  hostNetwork,  hostPID,  hostname,  imagePullSecrets,  initContainers,  nodeName,  nodeSelector,  overhead,  preemptionPolicy,  priority,  priorityClassName,  readinessGates,  restartPolicy,  runtimeClassName,  schedulerName,  securityContext,  serviceAccount,  serviceAccountName,  setHostnameAsFQDN,  shareProcessNamespace,  subdomain,  terminationGracePeriodSeconds,  timeoutSeconds,  tolerations,  topologySpreadConstraints,  volumes,  super.hashCode());
  }
  public class ContainersNestedImpl<N> extends io.fabric8.kubernetes.api.model.ContainerFluentImpl<io.fabric8.knative.serving.v1.RevisionSpecFluent.ContainersNested<N>> implements io.fabric8.knative.serving.v1.RevisionSpecFluent.ContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ContainersNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(this, item);
    }
    ContainersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ContainerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) RevisionSpecFluentImpl.this.setToContainers(index,builder.build());
    }
    public N endContainer() {
      return and();
    }
    
  }
  public class InitContainersNestedImpl<N> extends io.fabric8.kubernetes.api.model.ContainerFluentImpl<io.fabric8.knative.serving.v1.RevisionSpecFluent.InitContainersNested<N>> implements io.fabric8.knative.serving.v1.RevisionSpecFluent.InitContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    InitContainersNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(this, item);
    }
    InitContainersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ContainerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) RevisionSpecFluentImpl.this.setToInitContainers(index,builder.build());
    }
    public N endInitContainer() {
      return and();
    }
    
  }
  public class VolumesNestedImpl<N> extends io.fabric8.kubernetes.api.model.VolumeFluentImpl<io.fabric8.knative.serving.v1.RevisionSpecFluent.VolumesNested<N>> implements io.fabric8.knative.serving.v1.RevisionSpecFluent.VolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    VolumesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Volume item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(this, item);
    }
    VolumesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(this);
    }
    io.fabric8.kubernetes.api.model.VolumeBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) RevisionSpecFluentImpl.this.setToVolumes(index,builder.build());
    }
    public N endVolume() {
      return and();
    }
    
  }
  
}