package io.fabric8.knative.eventing.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EventTypeSpecBuilder extends EventTypeSpecFluentImpl<EventTypeSpecBuilder> implements VisitableBuilder<EventTypeSpec,EventTypeSpecBuilder> {

    EventTypeSpecFluent<?> fluent;
    Boolean validationEnabled;

    public EventTypeSpecBuilder() {
        this(true);
    }

    public EventTypeSpecBuilder(Boolean validationEnabled) {
        this(new EventTypeSpec(), validationEnabled);
    }

    public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EventTypeSpec(), validationEnabled);
    }

    public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent,EventTypeSpec instance) {
        this(fluent, instance, true);
    }

    public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent,EventTypeSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBroker(instance.getBroker()); 
        fluent.withDescription(instance.getDescription()); 
        fluent.withSchema(instance.getSchema()); 
        fluent.withSchemaData(instance.getSchemaData()); 
        fluent.withSource(instance.getSource()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public EventTypeSpecBuilder(EventTypeSpec instance) {
        this(instance,true);
    }

    public EventTypeSpecBuilder(EventTypeSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBroker(instance.getBroker()); 
        this.withDescription(instance.getDescription()); 
        this.withSchema(instance.getSchema()); 
        this.withSchemaData(instance.getSchemaData()); 
        this.withSource(instance.getSource()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.v1beta1.EditableEventTypeSpec build() {
        EditableEventTypeSpec buildable = new EditableEventTypeSpec(fluent.getBroker(),fluent.getDescription(),fluent.getSchema(),fluent.getSchemaData(),fluent.getSource(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EventTypeSpecBuilder that = (EventTypeSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
