package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ChannelListBuilder extends ChannelListFluentImpl<ChannelListBuilder> implements VisitableBuilder<ChannelList,ChannelListBuilder> {

    ChannelListFluent<?> fluent;
    Boolean validationEnabled;

    public ChannelListBuilder() {
        this(true);
    }

    public ChannelListBuilder(Boolean validationEnabled) {
        this(new ChannelList(), validationEnabled);
    }

    public ChannelListBuilder(ChannelListFluent<?> fluent) {
        this(fluent, true);
    }

    public ChannelListBuilder(ChannelListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ChannelList(), validationEnabled);
    }

    public ChannelListBuilder(ChannelListFluent<?> fluent,ChannelList instance) {
        this(fluent, instance, true);
    }

    public ChannelListBuilder(ChannelListFluent<?> fluent,ChannelList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ChannelListBuilder(ChannelList instance) {
        this(instance,true);
    }

    public ChannelListBuilder(ChannelList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.messaging.v1.EditableChannelList build() {
        EditableChannelList buildable = new EditableChannelList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ChannelListBuilder that = (ChannelListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
