package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBindingListBuilder extends KafkaBindingListFluentImpl<KafkaBindingListBuilder> implements VisitableBuilder<KafkaBindingList,KafkaBindingListBuilder> {

    KafkaBindingListFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBindingListBuilder() {
        this(true);
    }

    public KafkaBindingListBuilder(Boolean validationEnabled) {
        this(new KafkaBindingList(), validationEnabled);
    }

    public KafkaBindingListBuilder(KafkaBindingListFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaBindingListBuilder(KafkaBindingListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaBindingList(), validationEnabled);
    }

    public KafkaBindingListBuilder(KafkaBindingListFluent<?> fluent,KafkaBindingList instance) {
        this(fluent, instance, true);
    }

    public KafkaBindingListBuilder(KafkaBindingListFluent<?> fluent,KafkaBindingList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBindingListBuilder(KafkaBindingList instance) {
        this(instance,true);
    }

    public KafkaBindingListBuilder(KafkaBindingList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.EditableKafkaBindingList build() {
        EditableKafkaBindingList buildable = new EditableKafkaBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBindingListBuilder that = (KafkaBindingListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
