package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface TriggerListFluent<A extends TriggerListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Trigger item);
    public A setToItems(int index,Trigger item);
    public A addToItems(Trigger... items);
    public A addAllToItems(Collection<Trigger> items);
    public A removeFromItems(Trigger... items);
    public A removeAllFromItems(Collection<Trigger> items);
    public A removeMatchingFromItems(Predicate<TriggerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Trigger> getItems();
    public List<Trigger> buildItems();
    public Trigger buildItem(int index);
    public Trigger buildFirstItem();
    public Trigger buildLastItem();
    public Trigger buildMatchingItem(Predicate<TriggerBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<TriggerBuilder> predicate);
    public A withItems(List<Trigger> items);
    public A withItems(Trigger... items);
    public Boolean hasItems();
    public TriggerListFluent.ItemsNested<A> addNewItem();
    public TriggerListFluent.ItemsNested<A> addNewItemLike(Trigger item);
    public TriggerListFluent.ItemsNested<A> setNewItemLike(int index,Trigger item);
    public TriggerListFluent.ItemsNested<A> editItem(int index);
    public TriggerListFluent.ItemsNested<A> editFirstItem();
    public TriggerListFluent.ItemsNested<A> editLastItem();
    public TriggerListFluent.ItemsNested<A> editMatchingItem(Predicate<TriggerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TriggerFluent<TriggerListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
