package io.fabric8.knative.eventing.contrib.awssqs.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface AwsSqsSourceSpecFluent<A extends AwsSqsSourceSpecFluent<A>> extends Fluent<A> {


    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public <K extends Object,V extends Object>A withAnnotations(Map<String,String> annotations);
    public Boolean hasAnnotations();
    public SecretKeySelector getAwsCredsSecret();
    public A withAwsCredsSecret(SecretKeySelector awsCredsSecret);
    public Boolean hasAwsCredsSecret();
    public A withNewAwsCredsSecret(String key,String name,Boolean optional);
    public String getQueueUrl();
    public A withQueueUrl(String queueUrl);
    public Boolean hasQueueUrl();
    public A withNewQueueUrl(StringBuilder arg1);
    public A withNewQueueUrl(int[] arg1,int arg2,int arg3);
    public A withNewQueueUrl(char[] arg1);
    public A withNewQueueUrl(StringBuffer arg1);
    public A withNewQueueUrl(byte[] arg1,int arg2);
    public A withNewQueueUrl(byte[] arg1);
    public A withNewQueueUrl(char[] arg1,int arg2,int arg3);
    public A withNewQueueUrl(byte[] arg1,int arg2,int arg3);
    public A withNewQueueUrl(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewQueueUrl(String arg1);
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public Boolean hasServiceAccountName();
    public A withNewServiceAccountName(StringBuilder arg1);
    public A withNewServiceAccountName(int[] arg1,int arg2,int arg3);
    public A withNewServiceAccountName(char[] arg1);
    public A withNewServiceAccountName(StringBuffer arg1);
    public A withNewServiceAccountName(byte[] arg1,int arg2);
    public A withNewServiceAccountName(byte[] arg1);
    public A withNewServiceAccountName(char[] arg1,int arg2,int arg3);
    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3);
    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewServiceAccountName(String arg1);
    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getSink();
    public ObjectReference buildSink();
    public A withSink(ObjectReference sink);
    public Boolean hasSink();
    public AwsSqsSourceSpecFluent.SinkNested<A> withNewSink();
    public AwsSqsSourceSpecFluent.SinkNested<A> withNewSinkLike(ObjectReference item);
    public AwsSqsSourceSpecFluent.SinkNested<A> editSink();
    public AwsSqsSourceSpecFluent.SinkNested<A> editOrNewSink();
    public AwsSqsSourceSpecFluent.SinkNested<A> editOrNewSinkLike(ObjectReference item);
    public interface SinkNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<AwsSqsSourceSpecFluent.SinkNested<N>> {

            public N and();
            public N endSink();    }


}
