package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitLabBindingSpecBuilder extends GitLabBindingSpecFluentImpl<GitLabBindingSpecBuilder> implements VisitableBuilder<GitLabBindingSpec,GitLabBindingSpecBuilder> {

    GitLabBindingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public GitLabBindingSpecBuilder() {
        this(true);
    }

    public GitLabBindingSpecBuilder(Boolean validationEnabled) {
        this(new GitLabBindingSpec(), validationEnabled);
    }

    public GitLabBindingSpecBuilder(GitLabBindingSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public GitLabBindingSpecBuilder(GitLabBindingSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new GitLabBindingSpec(), validationEnabled);
    }

    public GitLabBindingSpecBuilder(GitLabBindingSpecFluent<?> fluent,GitLabBindingSpec instance) {
        this(fluent, instance, true);
    }

    public GitLabBindingSpecBuilder(GitLabBindingSpecFluent<?> fluent,GitLabBindingSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAccessToken(instance.getAccessToken()); 
        fluent.withSubject(instance.getSubject()); 
        this.validationEnabled = validationEnabled; 
    }

    public GitLabBindingSpecBuilder(GitLabBindingSpec instance) {
        this(instance,true);
    }

    public GitLabBindingSpecBuilder(GitLabBindingSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAccessToken(instance.getAccessToken()); 
        this.withSubject(instance.getSubject()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.EditableGitLabBindingSpec build() {
        EditableGitLabBindingSpec buildable = new EditableGitLabBindingSpec(fluent.getAccessToken(),fluent.getSubject());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitLabBindingSpecBuilder that = (GitLabBindingSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
