package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class KafkaBindingListFluentImpl<A extends KafkaBindingListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaBindingListFluent<A> {

    private String apiVersion;
    private List<KafkaBindingBuilder> items;
    private String kind;
    private ListMeta metadata;

    public KafkaBindingListFluentImpl() {
    }

    public KafkaBindingListFluentImpl(KafkaBindingList instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,KafkaBinding item) {
        if (this.items == null) {this.items = new ArrayList<KafkaBindingBuilder>();}
        KafkaBindingBuilder builder = new KafkaBindingBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,KafkaBinding item) {
        if (this.items == null) {this.items = new ArrayList<KafkaBindingBuilder>();}
        KafkaBindingBuilder builder = new KafkaBindingBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToItems(KafkaBinding... items) {
        if (this.items == null) {this.items = new ArrayList<KafkaBindingBuilder>();}
        for (KafkaBinding item : items) {KafkaBindingBuilder builder = new KafkaBindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<KafkaBinding> items) {
        if (this.items == null) {this.items = new ArrayList<KafkaBindingBuilder>();}
        for (KafkaBinding item : items) {KafkaBindingBuilder builder = new KafkaBindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(KafkaBinding... items) {
        for (KafkaBinding item : items) {KafkaBindingBuilder builder = new KafkaBindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<KafkaBinding> items) {
        for (KafkaBinding item : items) {KafkaBindingBuilder builder = new KafkaBindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromItems(Predicate<KafkaBindingBuilder> predicate) {
        if (items == null) return (A) this;
        final Iterator<KafkaBindingBuilder> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          KafkaBindingBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<KafkaBinding> getItems() {
        return build(items);
    }

    public List<KafkaBinding> buildItems() {
        return build(items);
    }

    public KafkaBinding buildItem(int index) {
        return this.items.get(index).build();
    }

    public KafkaBinding buildFirstItem() {
        return this.items.get(0).build();
    }

    public KafkaBinding buildLastItem() {
        return this.items.get(items.size() - 1).build();
    }

    public KafkaBinding buildMatchingItem(Predicate<KafkaBindingBuilder> predicate) {
        for (KafkaBindingBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingItem(Predicate<KafkaBindingBuilder> predicate) {
        for (KafkaBindingBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withItems(List<KafkaBinding> items) {
        if (this.items != null) { _visitables.get("items").removeAll(this.items);}
        if (items != null) {this.items = new ArrayList<KafkaBindingBuilder>(); for (KafkaBinding item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(KafkaBinding... items) {
        if (this.items != null) {this.items.clear();}
        if (items != null) {for (KafkaBinding item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems() {
        return items != null && !items.isEmpty();
    }

    public KafkaBindingListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    public KafkaBindingListFluent.ItemsNested<A> addNewItemLike(KafkaBinding item) {
        return new ItemsNestedImpl(-1, item);
    }

    public KafkaBindingListFluent.ItemsNested<A> setNewItemLike(int index,KafkaBinding item) {
        return new ItemsNestedImpl(index, item);
    }

    public KafkaBindingListFluent.ItemsNested<A> editItem(int index) {
        if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
        return setNewItemLike(index, buildItem(index));
    }

    public KafkaBindingListFluent.ItemsNested<A> editFirstItem() {
        if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
        return setNewItemLike(0, buildItem(0));
    }

    public KafkaBindingListFluent.ItemsNested<A> editLastItem() {
        int index = items.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
        return setNewItemLike(index, buildItem(index));
    }

    public KafkaBindingListFluent.ItemsNested<A> editMatchingItem(Predicate<KafkaBindingBuilder> predicate) {
        int index = -1;
        for (int i=0;i<items.size();i++) { 
        if (predicate.test(items.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
        return setNewItemLike(index, buildItem(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public ListMeta getMetadata() {
        return this.metadata;
    }

    public A withMetadata(ListMeta metadata) {
        this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
        return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaBindingListFluentImpl that = (KafkaBindingListFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (items != null ? !items.equals(that.items) :that.items != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
    }

    public class ItemsNestedImpl<N> extends KafkaBindingFluentImpl<KafkaBindingListFluent.ItemsNested<N>> implements KafkaBindingListFluent.ItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaBindingBuilder builder;
        private final int index;

            ItemsNestedImpl(int index,KafkaBinding item) {
                this.index = index;
                this.builder = new KafkaBindingBuilder(this, item);
                        
            }

            ItemsNestedImpl() {
                this.index = -1;
                this.builder = new KafkaBindingBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBindingListFluentImpl.this.setToItems(index,builder.build());
            }

            public N endItem() {
                return and();
            }
    }


}
