package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.tracker.ReferenceFluentImpl;
import io.fabric8.knative.internal.pkg.tracker.Reference;
import java.lang.StringBuffer;
import io.fabric8.knative.internal.pkg.tracker.ReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

public class KafkaBindingSpecFluentImpl<A extends KafkaBindingSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaBindingSpecFluent<A> {

    private List<String> bootstrapServers;
    private KafkaNetSpecBuilder net;
    private ReferenceBuilder subject;

    public KafkaBindingSpecFluentImpl() {
    }

    public KafkaBindingSpecFluentImpl(KafkaBindingSpec instance) {
        this.withBootstrapServers(instance.getBootstrapServers()); 
        this.withNet(instance.getNet()); 
        this.withSubject(instance.getSubject()); 
    }

    public A addToBootstrapServers(int index,String item) {
        if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
        this.bootstrapServers.add(index, item);
        return (A)this;
    }

    public A setToBootstrapServers(int index,String item) {
        if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
        this.bootstrapServers.set(index, item); return (A)this;
    }

    public A addToBootstrapServers(String... items) {
        if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
        for (String item : items) {this.bootstrapServers.add(item);} return (A)this;
    }

    public A addAllToBootstrapServers(Collection<String> items) {
        if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
        for (String item : items) {this.bootstrapServers.add(item);} return (A)this;
    }

    public A removeFromBootstrapServers(String... items) {
        for (String item : items) {if (this.bootstrapServers!= null){ this.bootstrapServers.remove(item);}} return (A)this;
    }

    public A removeAllFromBootstrapServers(Collection<String> items) {
        for (String item : items) {if (this.bootstrapServers!= null){ this.bootstrapServers.remove(item);}} return (A)this;
    }

    public List<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getBootstrapServer(int index) {
        return this.bootstrapServers.get(index);
    }

    public String getFirstBootstrapServer() {
        return this.bootstrapServers.get(0);
    }

    public String getLastBootstrapServer() {
        return this.bootstrapServers.get(bootstrapServers.size() - 1);
    }

    public String getMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item: bootstrapServers) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item: bootstrapServers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withBootstrapServers(List<String> bootstrapServers) {
        if (this.bootstrapServers != null) { _visitables.get("bootstrapServers").removeAll(this.bootstrapServers);}
        if (bootstrapServers != null) {this.bootstrapServers = new ArrayList<String>(); for (String item : bootstrapServers){this.addToBootstrapServers(item);}} else { this.bootstrapServers = null;} return (A) this;
    }

    public A withBootstrapServers(String... bootstrapServers) {
        if (this.bootstrapServers != null) {this.bootstrapServers.clear();}
        if (bootstrapServers != null) {for (String item :bootstrapServers){ this.addToBootstrapServers(item);}} return (A) this;
    }

    public Boolean hasBootstrapServers() {
        return bootstrapServers != null && !bootstrapServers.isEmpty();
    }

    public A addNewBootstrapServer(StringBuilder arg1) {
        return (A)addToBootstrapServers(new String(arg1));
    }

    public A addNewBootstrapServer(int[] arg1,int arg2,int arg3) {
        return (A)addToBootstrapServers(new String(arg1, arg2, arg3));
    }

    public A addNewBootstrapServer(char[] arg1) {
        return (A)addToBootstrapServers(new String(arg1));
    }

    public A addNewBootstrapServer(StringBuffer arg1) {
        return (A)addToBootstrapServers(new String(arg1));
    }

    public A addNewBootstrapServer(byte[] arg1,int arg2) {
        return (A)addToBootstrapServers(new String(arg1, arg2));
    }

    public A addNewBootstrapServer(byte[] arg1) {
        return (A)addToBootstrapServers(new String(arg1));
    }

    public A addNewBootstrapServer(char[] arg1,int arg2,int arg3) {
        return (A)addToBootstrapServers(new String(arg1, arg2, arg3));
    }

    public A addNewBootstrapServer(byte[] arg1,int arg2,int arg3) {
        return (A)addToBootstrapServers(new String(arg1, arg2, arg3));
    }

    public A addNewBootstrapServer(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToBootstrapServers(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewBootstrapServer(String arg1) {
        return (A)addToBootstrapServers(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNet instead.
 * @return The buildable object.
 */
@Deprecated public KafkaNetSpec getNet() {
        return this.net!=null?this.net.build():null;
    }

    public KafkaNetSpec buildNet() {
        return this.net!=null?this.net.build():null;
    }

    public A withNet(KafkaNetSpec net) {
        _visitables.get("net").remove(this.net);
        if (net!=null){ this.net= new KafkaNetSpecBuilder(net); _visitables.get("net").add(this.net);} return (A) this;
    }

    public Boolean hasNet() {
        return this.net != null;
    }

    public KafkaBindingSpecFluent.NetNested<A> withNewNet() {
        return new NetNestedImpl();
    }

    public KafkaBindingSpecFluent.NetNested<A> withNewNetLike(KafkaNetSpec item) {
        return new NetNestedImpl(item);
    }

    public KafkaBindingSpecFluent.NetNested<A> editNet() {
        return withNewNetLike(getNet());
    }

    public KafkaBindingSpecFluent.NetNested<A> editOrNewNet() {
        return withNewNetLike(getNet() != null ? getNet(): new KafkaNetSpecBuilder().build());
    }

    public KafkaBindingSpecFluent.NetNested<A> editOrNewNetLike(KafkaNetSpec item) {
        return withNewNetLike(getNet() != null ? getNet(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSubject instead.
 * @return The buildable object.
 */
@Deprecated public Reference getSubject() {
        return this.subject!=null?this.subject.build():null;
    }

    public Reference buildSubject() {
        return this.subject!=null?this.subject.build():null;
    }

    public A withSubject(Reference subject) {
        _visitables.get("subject").remove(this.subject);
        if (subject!=null){ this.subject= new ReferenceBuilder(subject); _visitables.get("subject").add(this.subject);} return (A) this;
    }

    public Boolean hasSubject() {
        return this.subject != null;
    }

    public KafkaBindingSpecFluent.SubjectNested<A> withNewSubject() {
        return new SubjectNestedImpl();
    }

    public KafkaBindingSpecFluent.SubjectNested<A> withNewSubjectLike(Reference item) {
        return new SubjectNestedImpl(item);
    }

    public KafkaBindingSpecFluent.SubjectNested<A> editSubject() {
        return withNewSubjectLike(getSubject());
    }

    public KafkaBindingSpecFluent.SubjectNested<A> editOrNewSubject() {
        return withNewSubjectLike(getSubject() != null ? getSubject(): new ReferenceBuilder().build());
    }

    public KafkaBindingSpecFluent.SubjectNested<A> editOrNewSubjectLike(Reference item) {
        return withNewSubjectLike(getSubject() != null ? getSubject(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaBindingSpecFluentImpl that = (KafkaBindingSpecFluentImpl) o;
        if (bootstrapServers != null ? !bootstrapServers.equals(that.bootstrapServers) :that.bootstrapServers != null) return false;
        if (net != null ? !net.equals(that.net) :that.net != null) return false;
        if (subject != null ? !subject.equals(that.subject) :that.subject != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(bootstrapServers,  net,  subject,  super.hashCode());
    }

    public class NetNestedImpl<N> extends KafkaNetSpecFluentImpl<KafkaBindingSpecFluent.NetNested<N>> implements KafkaBindingSpecFluent.NetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaNetSpecBuilder builder;

            NetNestedImpl(KafkaNetSpec item) {
                this.builder = new KafkaNetSpecBuilder(this, item);
                        
            }

            NetNestedImpl() {
                this.builder = new KafkaNetSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBindingSpecFluentImpl.this.withNet(builder.build());
            }

            public N endNet() {
                return and();
            }
    }


    public class SubjectNestedImpl<N> extends ReferenceFluentImpl<KafkaBindingSpecFluent.SubjectNested<N>> implements KafkaBindingSpecFluent.SubjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ReferenceBuilder builder;

            SubjectNestedImpl(Reference item) {
                this.builder = new ReferenceBuilder(this, item);
                        
            }

            SubjectNestedImpl() {
                this.builder = new ReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBindingSpecFluentImpl.this.withSubject(builder.build());
            }

            public N endSubject() {
                return and();
            }
    }


}
