package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerBuilder extends TriggerFluentImpl<TriggerBuilder> implements VisitableBuilder<Trigger,TriggerBuilder> {

    TriggerFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerBuilder() {
        this(true);
    }

    public TriggerBuilder(Boolean validationEnabled) {
        this(new Trigger(), validationEnabled);
    }

    public TriggerBuilder(TriggerFluent<?> fluent) {
        this(fluent, true);
    }

    public TriggerBuilder(TriggerFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Trigger(), validationEnabled);
    }

    public TriggerBuilder(TriggerFluent<?> fluent,Trigger instance) {
        this(fluent, instance, true);
    }

    public TriggerBuilder(TriggerFluent<?> fluent,Trigger instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public TriggerBuilder(Trigger instance) {
        this(instance,true);
    }

    public TriggerBuilder(Trigger instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.v1.EditableTrigger build() {
        EditableTrigger buildable = new EditableTrigger(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerBuilder that = (TriggerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
