package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ChannelFluent<A extends ChannelFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ChannelFluent.MetadataNested<A> withNewMetadata();
    public ChannelFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ChannelFluent.MetadataNested<A> editMetadata();
    public ChannelFluent.MetadataNested<A> editOrNewMetadata();
    public ChannelFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ChannelSpec getSpec();
    public ChannelSpec buildSpec();
    public A withSpec(ChannelSpec spec);
    public Boolean hasSpec();
    public ChannelFluent.SpecNested<A> withNewSpec();
    public ChannelFluent.SpecNested<A> withNewSpecLike(ChannelSpec item);
    public ChannelFluent.SpecNested<A> editSpec();
    public ChannelFluent.SpecNested<A> editOrNewSpec();
    public ChannelFluent.SpecNested<A> editOrNewSpecLike(ChannelSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public ChannelStatus getStatus();
    public ChannelStatus buildStatus();
    public A withStatus(ChannelStatus status);
    public Boolean hasStatus();
    public ChannelFluent.StatusNested<A> withNewStatus();
    public ChannelFluent.StatusNested<A> withNewStatusLike(ChannelStatus item);
    public ChannelFluent.StatusNested<A> editStatus();
    public ChannelFluent.StatusNested<A> editOrNewStatus();
    public ChannelFluent.StatusNested<A> editOrNewStatusLike(ChannelStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ChannelFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ChannelSpecFluent<ChannelFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ChannelStatusFluent<ChannelFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
