package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface RevisionStatusFluent<A extends RevisionStatusFluent<A>> extends Fluent<A> {


    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public <K extends Object,V extends Object>A withAnnotations(Map<String,String> annotations);
    public Boolean hasAnnotations();
    public A addToConditions(int index,Condition item);
    public A setToConditions(int index,Condition item);
    public A addToConditions(Condition... items);
    public A addAllToConditions(Collection<Condition> items);
    public A removeFromConditions(Condition... items);
    public A removeAllFromConditions(Collection<Condition> items);
    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions();
    public List<Condition> buildConditions();
    public Condition buildCondition(int index);
    public Condition buildFirstCondition();
    public Condition buildLastCondition();
    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate);
    public A withConditions(List<Condition> conditions);
    public A withConditions(Condition... conditions);
    public Boolean hasConditions();
    public RevisionStatusFluent.ConditionsNested<A> addNewCondition();
    public RevisionStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item);
    public RevisionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item);
    public RevisionStatusFluent.ConditionsNested<A> editCondition(int index);
    public RevisionStatusFluent.ConditionsNested<A> editFirstCondition();
    public RevisionStatusFluent.ConditionsNested<A> editLastCondition();
    public RevisionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate);
    public A addToContainerStatuses(int index,ContainerStatuses item);
    public A setToContainerStatuses(int index,ContainerStatuses item);
    public A addToContainerStatuses(ContainerStatuses... items);
    public A addAllToContainerStatuses(Collection<ContainerStatuses> items);
    public A removeFromContainerStatuses(ContainerStatuses... items);
    public A removeAllFromContainerStatuses(Collection<ContainerStatuses> items);
    public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusesBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildContainerStatuses instead.
 * @return The buildable object.
 */
@Deprecated public List<ContainerStatuses> getContainerStatuses();
    public List<ContainerStatuses> buildContainerStatuses();
    public ContainerStatuses buildContainerStatus(int index);
    public ContainerStatuses buildFirstContainerStatus();
    public ContainerStatuses buildLastContainerStatus();
    public ContainerStatuses buildMatchingContainerStatus(Predicate<ContainerStatusesBuilder> predicate);
    public Boolean hasMatchingContainerStatus(Predicate<ContainerStatusesBuilder> predicate);
    public A withContainerStatuses(List<ContainerStatuses> containerStatuses);
    public A withContainerStatuses(ContainerStatuses... containerStatuses);
    public Boolean hasContainerStatuses();
    public A addNewContainerStatus(String imageDigest,String name);
    public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatus();
    public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatuses item);
    public RevisionStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(int index,ContainerStatuses item);
    public RevisionStatusFluent.ContainerStatusesNested<A> editContainerStatus(int index);
    public RevisionStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus();
    public RevisionStatusFluent.ContainerStatusesNested<A> editLastContainerStatus();
    public RevisionStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusesBuilder> predicate);
    public String getImageDigest();
    public A withImageDigest(String imageDigest);
    public Boolean hasImageDigest();
    public A withNewImageDigest(StringBuilder arg1);
    public A withNewImageDigest(int[] arg1,int arg2,int arg3);
    public A withNewImageDigest(char[] arg1);
    public A withNewImageDigest(StringBuffer arg1);
    public A withNewImageDigest(byte[] arg1,int arg2);
    public A withNewImageDigest(byte[] arg1);
    public A withNewImageDigest(char[] arg1,int arg2,int arg3);
    public A withNewImageDigest(byte[] arg1,int arg2,int arg3);
    public A withNewImageDigest(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImageDigest(String arg1);
    public String getLogUrl();
    public A withLogUrl(String logUrl);
    public Boolean hasLogUrl();
    public A withNewLogUrl(StringBuilder arg1);
    public A withNewLogUrl(int[] arg1,int arg2,int arg3);
    public A withNewLogUrl(char[] arg1);
    public A withNewLogUrl(StringBuffer arg1);
    public A withNewLogUrl(byte[] arg1,int arg2);
    public A withNewLogUrl(byte[] arg1);
    public A withNewLogUrl(char[] arg1,int arg2,int arg3);
    public A withNewLogUrl(byte[] arg1,int arg2,int arg3);
    public A withNewLogUrl(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewLogUrl(String arg1);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(long arg1);
    public String getServiceName();
    public A withServiceName(String serviceName);
    public Boolean hasServiceName();
    public A withNewServiceName(StringBuilder arg1);
    public A withNewServiceName(int[] arg1,int arg2,int arg3);
    public A withNewServiceName(char[] arg1);
    public A withNewServiceName(StringBuffer arg1);
    public A withNewServiceName(byte[] arg1,int arg2);
    public A withNewServiceName(byte[] arg1);
    public A withNewServiceName(char[] arg1,int arg2,int arg3);
    public A withNewServiceName(byte[] arg1,int arg2,int arg3);
    public A withNewServiceName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewServiceName(String arg1);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConditionFluent<RevisionStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface ContainerStatusesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerStatusesFluent<RevisionStatusFluent.ContainerStatusesNested<N>> {

            public N and();
            public N endContainerStatus();    }


}
