package io.fabric8.knative.eventing.contrib.awssqs.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface AwsSqsSourceListFluent<A extends AwsSqsSourceListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,AwsSqsSource item);
    public A setToItems(int index,AwsSqsSource item);
    public A addToItems(AwsSqsSource... items);
    public A addAllToItems(Collection<AwsSqsSource> items);
    public A removeFromItems(AwsSqsSource... items);
    public A removeAllFromItems(Collection<AwsSqsSource> items);
    public A removeMatchingFromItems(Predicate<AwsSqsSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<AwsSqsSource> getItems();
    public List<AwsSqsSource> buildItems();
    public AwsSqsSource buildItem(int index);
    public AwsSqsSource buildFirstItem();
    public AwsSqsSource buildLastItem();
    public AwsSqsSource buildMatchingItem(Predicate<AwsSqsSourceBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<AwsSqsSourceBuilder> predicate);
    public A withItems(List<AwsSqsSource> items);
    public A withItems(AwsSqsSource... items);
    public Boolean hasItems();
    public AwsSqsSourceListFluent.ItemsNested<A> addNewItem();
    public AwsSqsSourceListFluent.ItemsNested<A> addNewItemLike(AwsSqsSource item);
    public AwsSqsSourceListFluent.ItemsNested<A> setNewItemLike(int index,AwsSqsSource item);
    public AwsSqsSourceListFluent.ItemsNested<A> editItem(int index);
    public AwsSqsSourceListFluent.ItemsNested<A> editFirstItem();
    public AwsSqsSourceListFluent.ItemsNested<A> editLastItem();
    public AwsSqsSourceListFluent.ItemsNested<A> editMatchingItem(Predicate<AwsSqsSourceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AwsSqsSourceFluent<AwsSqsSourceListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
