package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface BrokerListFluent<A extends BrokerListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,Broker item);
    public A setToItems(int index,Broker item);
    public A addToItems(Broker... items);
    public A addAllToItems(Collection<Broker> items);
    public A removeFromItems(Broker... items);
    public A removeAllFromItems(Collection<Broker> items);
    public A removeMatchingFromItems(Predicate<BrokerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Broker> getItems();
    public List<Broker> buildItems();
    public Broker buildItem(int index);
    public Broker buildFirstItem();
    public Broker buildLastItem();
    public Broker buildMatchingItem(Predicate<BrokerBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<BrokerBuilder> predicate);
    public A withItems(List<Broker> items);
    public A withItems(Broker... items);
    public Boolean hasItems();
    public BrokerListFluent.ItemsNested<A> addNewItem();
    public BrokerListFluent.ItemsNested<A> addNewItemLike(Broker item);
    public BrokerListFluent.ItemsNested<A> setNewItemLike(int index,Broker item);
    public BrokerListFluent.ItemsNested<A> editItem(int index);
    public BrokerListFluent.ItemsNested<A> editFirstItem();
    public BrokerListFluent.ItemsNested<A> editLastItem();
    public BrokerListFluent.ItemsNested<A> editMatchingItem(Predicate<BrokerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BrokerFluent<BrokerListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
