package io.fabric8.knative.internal.eventing.pkg.apis.duck.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class SubscriberSpecFluentImpl<A extends SubscriberSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubscriberSpecFluent<A> {

    private DeliverySpecBuilder delivery;
    private Long generation;
    private String replyUri;
    private String subscriberUri;
    private String uid;

    public SubscriberSpecFluentImpl() {
    }

    public SubscriberSpecFluentImpl(SubscriberSpec instance) {
        this.withDelivery(instance.getDelivery()); 
        this.withGeneration(instance.getGeneration()); 
        this.withReplyUri(instance.getReplyUri()); 
        this.withSubscriberUri(instance.getSubscriberUri()); 
        this.withUid(instance.getUid()); 
    }

    
/**
 * This method has been deprecated, please use method buildDelivery instead.
 * @return The buildable object.
 */
@Deprecated public DeliverySpec getDelivery() {
        return this.delivery!=null?this.delivery.build():null;
    }

    public DeliverySpec buildDelivery() {
        return this.delivery!=null?this.delivery.build():null;
    }

    public A withDelivery(DeliverySpec delivery) {
        _visitables.get("delivery").remove(this.delivery);
        if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} return (A) this;
    }

    public Boolean hasDelivery() {
        return this.delivery != null;
    }

    public SubscriberSpecFluent.DeliveryNested<A> withNewDelivery() {
        return new DeliveryNestedImpl();
    }

    public SubscriberSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNestedImpl(item);
    }

    public SubscriberSpecFluent.DeliveryNested<A> editDelivery() {
        return withNewDeliveryLike(getDelivery());
    }

    public SubscriberSpecFluent.DeliveryNested<A> editOrNewDelivery() {
        return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new DeliverySpecBuilder().build());
    }

    public SubscriberSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
    }

    public Long getGeneration() {
        return this.generation;
    }

    public A withGeneration(Long generation) {
        this.generation=generation; return (A) this;
    }

    public Boolean hasGeneration() {
        return this.generation != null;
    }

    public A withNewGeneration(long arg1) {
        return (A)withGeneration(new Long(arg1));
    }

    public String getReplyUri() {
        return this.replyUri;
    }

    public A withReplyUri(String replyUri) {
        this.replyUri=replyUri; return (A) this;
    }

    public Boolean hasReplyUri() {
        return this.replyUri != null;
    }

    public A withNewReplyUri(StringBuilder arg1) {
        return (A)withReplyUri(new String(arg1));
    }

    public A withNewReplyUri(int[] arg1,int arg2,int arg3) {
        return (A)withReplyUri(new String(arg1, arg2, arg3));
    }

    public A withNewReplyUri(char[] arg1) {
        return (A)withReplyUri(new String(arg1));
    }

    public A withNewReplyUri(StringBuffer arg1) {
        return (A)withReplyUri(new String(arg1));
    }

    public A withNewReplyUri(byte[] arg1,int arg2) {
        return (A)withReplyUri(new String(arg1, arg2));
    }

    public A withNewReplyUri(byte[] arg1) {
        return (A)withReplyUri(new String(arg1));
    }

    public A withNewReplyUri(char[] arg1,int arg2,int arg3) {
        return (A)withReplyUri(new String(arg1, arg2, arg3));
    }

    public A withNewReplyUri(byte[] arg1,int arg2,int arg3) {
        return (A)withReplyUri(new String(arg1, arg2, arg3));
    }

    public A withNewReplyUri(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withReplyUri(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewReplyUri(String arg1) {
        return (A)withReplyUri(new String(arg1));
    }

    public String getSubscriberUri() {
        return this.subscriberUri;
    }

    public A withSubscriberUri(String subscriberUri) {
        this.subscriberUri=subscriberUri; return (A) this;
    }

    public Boolean hasSubscriberUri() {
        return this.subscriberUri != null;
    }

    public A withNewSubscriberUri(StringBuilder arg1) {
        return (A)withSubscriberUri(new String(arg1));
    }

    public A withNewSubscriberUri(int[] arg1,int arg2,int arg3) {
        return (A)withSubscriberUri(new String(arg1, arg2, arg3));
    }

    public A withNewSubscriberUri(char[] arg1) {
        return (A)withSubscriberUri(new String(arg1));
    }

    public A withNewSubscriberUri(StringBuffer arg1) {
        return (A)withSubscriberUri(new String(arg1));
    }

    public A withNewSubscriberUri(byte[] arg1,int arg2) {
        return (A)withSubscriberUri(new String(arg1, arg2));
    }

    public A withNewSubscriberUri(byte[] arg1) {
        return (A)withSubscriberUri(new String(arg1));
    }

    public A withNewSubscriberUri(char[] arg1,int arg2,int arg3) {
        return (A)withSubscriberUri(new String(arg1, arg2, arg3));
    }

    public A withNewSubscriberUri(byte[] arg1,int arg2,int arg3) {
        return (A)withSubscriberUri(new String(arg1, arg2, arg3));
    }

    public A withNewSubscriberUri(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSubscriberUri(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSubscriberUri(String arg1) {
        return (A)withSubscriberUri(new String(arg1));
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid=uid; return (A) this;
    }

    public Boolean hasUid() {
        return this.uid != null;
    }

    public A withNewUid(StringBuilder arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(int[] arg1,int arg2,int arg3) {
        return (A)withUid(new String(arg1, arg2, arg3));
    }

    public A withNewUid(char[] arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuffer arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(byte[] arg1,int arg2) {
        return (A)withUid(new String(arg1, arg2));
    }

    public A withNewUid(byte[] arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(char[] arg1,int arg2,int arg3) {
        return (A)withUid(new String(arg1, arg2, arg3));
    }

    public A withNewUid(byte[] arg1,int arg2,int arg3) {
        return (A)withUid(new String(arg1, arg2, arg3));
    }

    public A withNewUid(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withUid(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewUid(String arg1) {
        return (A)withUid(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubscriberSpecFluentImpl that = (SubscriberSpecFluentImpl) o;
        if (delivery != null ? !delivery.equals(that.delivery) :that.delivery != null) return false;
        if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
        if (replyUri != null ? !replyUri.equals(that.replyUri) :that.replyUri != null) return false;
        if (subscriberUri != null ? !subscriberUri.equals(that.subscriberUri) :that.subscriberUri != null) return false;
        if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(delivery,  generation,  replyUri,  subscriberUri,  uid,  super.hashCode());
    }

    public class DeliveryNestedImpl<N> extends DeliverySpecFluentImpl<SubscriberSpecFluent.DeliveryNested<N>> implements SubscriberSpecFluent.DeliveryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DeliverySpecBuilder builder;

            DeliveryNestedImpl(DeliverySpec item) {
                this.builder = new DeliverySpecBuilder(this, item);
                        
            }

            DeliveryNestedImpl() {
                this.builder = new DeliverySpecBuilder(this);
                        
            }

            public N and() {
                return (N) SubscriberSpecFluentImpl.this.withDelivery(builder.build());
            }

            public N endDelivery() {
                return and();
            }
    }


}
