package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIVersionKindSelectorBuilder extends APIVersionKindSelectorFluentImpl<APIVersionKindSelectorBuilder> implements VisitableBuilder<APIVersionKindSelector,APIVersionKindSelectorBuilder> {

    APIVersionKindSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public APIVersionKindSelectorBuilder() {
        this(true);
    }

    public APIVersionKindSelectorBuilder(Boolean validationEnabled) {
        this(new APIVersionKindSelector(), validationEnabled);
    }

    public APIVersionKindSelectorBuilder(APIVersionKindSelectorFluent<?> fluent) {
        this(fluent, true);
    }

    public APIVersionKindSelectorBuilder(APIVersionKindSelectorFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new APIVersionKindSelector(), validationEnabled);
    }

    public APIVersionKindSelectorBuilder(APIVersionKindSelectorFluent<?> fluent,APIVersionKindSelector instance) {
        this(fluent, instance, true);
    }

    public APIVersionKindSelectorBuilder(APIVersionKindSelectorFluent<?> fluent,APIVersionKindSelector instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withSelector(instance.getSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIVersionKindSelectorBuilder(APIVersionKindSelector instance) {
        this(instance,true);
    }

    public APIVersionKindSelectorBuilder(APIVersionKindSelector instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withSelector(instance.getSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.sources.v1beta1.EditableAPIVersionKindSelector build() {
        EditableAPIVersionKindSelector buildable = new EditableAPIVersionKindSelector(fluent.getApiVersion(),fluent.getKind(),fluent.getSelector());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIVersionKindSelectorBuilder that = (APIVersionKindSelectorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
