package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CouchDbSourceListBuilder extends CouchDbSourceListFluentImpl<CouchDbSourceListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<CouchDbSourceList,CouchDbSourceListBuilder> {

    CouchDbSourceListFluent<?> fluent;
    Boolean validationEnabled;

    public CouchDbSourceListBuilder() {
        this(true);
    }

    public CouchDbSourceListBuilder(Boolean validationEnabled) {
        this(new CouchDbSourceList(), validationEnabled);
    }

    public CouchDbSourceListBuilder(CouchDbSourceListFluent<?> fluent) {
        this(fluent, true);
    }

    public CouchDbSourceListBuilder(CouchDbSourceListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CouchDbSourceList(), validationEnabled);
    }

    public CouchDbSourceListBuilder(CouchDbSourceListFluent<?> fluent,CouchDbSourceList instance) {
        this(fluent, instance, true);
    }

    public CouchDbSourceListBuilder(CouchDbSourceListFluent<?> fluent,CouchDbSourceList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public CouchDbSourceListBuilder(CouchDbSourceList instance) {
        this(instance,true);
    }

    public CouchDbSourceListBuilder(CouchDbSourceList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.couchdb.v1alpha1.EditableCouchDbSourceList build() {
        EditableCouchDbSourceList buildable = new EditableCouchDbSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CouchDbSourceListBuilder that = (CouchDbSourceListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
