package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitHubSourceBuilder extends GitHubSourceFluentImpl<GitHubSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<GitHubSource,GitHubSourceBuilder> {

    GitHubSourceFluent<?> fluent;
    Boolean validationEnabled;

    public GitHubSourceBuilder() {
        this(true);
    }

    public GitHubSourceBuilder(Boolean validationEnabled) {
        this(new GitHubSource(), validationEnabled);
    }

    public GitHubSourceBuilder(GitHubSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public GitHubSourceBuilder(GitHubSourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new GitHubSource(), validationEnabled);
    }

    public GitHubSourceBuilder(GitHubSourceFluent<?> fluent,GitHubSource instance) {
        this(fluent, instance, true);
    }

    public GitHubSourceBuilder(GitHubSourceFluent<?> fluent,GitHubSource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public GitHubSourceBuilder(GitHubSource instance) {
        this(instance,true);
    }

    public GitHubSourceBuilder(GitHubSource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.EditableGitHubSource build() {
        EditableGitHubSource buildable = new EditableGitHubSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitHubSourceBuilder that = (GitHubSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
