package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface GitHubSourceListFluent<A extends GitHubSourceListFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,GitHubSource item);
    public A setToItems(int index,GitHubSource item);
    public A addToItems(GitHubSource... items);
    public A addAllToItems(Collection<GitHubSource> items);
    public A removeFromItems(GitHubSource... items);
    public A removeAllFromItems(Collection<GitHubSource> items);
    public A removeMatchingFromItems(Predicate<GitHubSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<GitHubSource> getItems();
    public List<GitHubSource> buildItems();
    public GitHubSource buildItem(int index);
    public GitHubSource buildFirstItem();
    public GitHubSource buildLastItem();
    public GitHubSource buildMatchingItem(Predicate<GitHubSourceBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<GitHubSourceBuilder> predicate);
    public A withItems(List<GitHubSource> items);
    public A withItems(GitHubSource... items);
    public Boolean hasItems();
    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceListFluent.ItemsNested<A> addNewItem();
    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceListFluent.ItemsNested<A> addNewItemLike(GitHubSource item);
    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceListFluent.ItemsNested<A> setNewItemLike(int index,GitHubSource item);
    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceListFluent.ItemsNested<A> editItem(int index);
    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceListFluent.ItemsNested<A> editFirstItem();
    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceListFluent.ItemsNested<A> editLastItem();
    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceListFluent.ItemsNested<A> editMatchingItem(Predicate<GitHubSourceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GitHubSourceFluent<io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
