package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitLabSourceSpecBuilder extends GitLabSourceSpecFluentImpl<GitLabSourceSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<GitLabSourceSpec,GitLabSourceSpecBuilder> {

    GitLabSourceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public GitLabSourceSpecBuilder() {
        this(true);
    }

    public GitLabSourceSpecBuilder(Boolean validationEnabled) {
        this(new GitLabSourceSpec(), validationEnabled);
    }

    public GitLabSourceSpecBuilder(GitLabSourceSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public GitLabSourceSpecBuilder(GitLabSourceSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new GitLabSourceSpec(), validationEnabled);
    }

    public GitLabSourceSpecBuilder(GitLabSourceSpecFluent<?> fluent,GitLabSourceSpec instance) {
        this(fluent, instance, true);
    }

    public GitLabSourceSpecBuilder(GitLabSourceSpecFluent<?> fluent,GitLabSourceSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAccessToken(instance.getAccessToken()); 
        fluent.withEventTypes(instance.getEventTypes()); 
        fluent.withProjectUrl(instance.getProjectUrl()); 
        fluent.withSecretToken(instance.getSecretToken()); 
        fluent.withServiceAccountName(instance.getServiceAccountName()); 
        fluent.withSink(instance.getSink()); 
        fluent.withSslverify(instance.getSslverify()); 
        this.validationEnabled = validationEnabled; 
    }

    public GitLabSourceSpecBuilder(GitLabSourceSpec instance) {
        this(instance,true);
    }

    public GitLabSourceSpecBuilder(GitLabSourceSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAccessToken(instance.getAccessToken()); 
        this.withEventTypes(instance.getEventTypes()); 
        this.withProjectUrl(instance.getProjectUrl()); 
        this.withSecretToken(instance.getSecretToken()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSink(instance.getSink()); 
        this.withSslverify(instance.getSslverify()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.EditableGitLabSourceSpec build() {
        EditableGitLabSourceSpec buildable = new EditableGitLabSourceSpec(fluent.getAccessToken(),fluent.getEventTypes(),fluent.getProjectUrl(),fluent.getSecretToken(),fluent.getServiceAccountName(),fluent.getSink(),fluent.getSslverify());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitLabSourceSpecBuilder that = (GitLabSourceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
