package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaNetSpecFluentImpl<A extends KafkaNetSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaNetSpecFluent<A> {

    private KafkaSASLSpecBuilder sasl;
    private KafkaTLSSpecBuilder tls;

    public KafkaNetSpecFluentImpl() {
    }

    public KafkaNetSpecFluentImpl(KafkaNetSpec instance) {
        this.withSasl(instance.getSasl()); 
        this.withTls(instance.getTls()); 
    }

    
/**
 * This method has been deprecated, please use method buildSasl instead.
 * @return The buildable object.
 */
@Deprecated public KafkaSASLSpec getSasl() {
        return this.sasl!=null?this.sasl.build():null;
    }

    public KafkaSASLSpec buildSasl() {
        return this.sasl!=null?this.sasl.build():null;
    }

    public A withSasl(KafkaSASLSpec sasl) {
        _visitables.get("sasl").remove(this.sasl);
        if (sasl!=null){ this.sasl= new KafkaSASLSpecBuilder(sasl); _visitables.get("sasl").add(this.sasl);} return (A) this;
    }

    public Boolean hasSasl() {
        return this.sasl != null;
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.SaslNested<A> withNewSasl() {
        return new SaslNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.SaslNested<A> withNewSaslLike(KafkaSASLSpec item) {
        return new SaslNestedImpl(item);
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.SaslNested<A> editSasl() {
        return withNewSaslLike(getSasl());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.SaslNested<A> editOrNewSasl() {
        return withNewSaslLike(getSasl() != null ? getSasl(): new KafkaSASLSpecBuilder().build());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.SaslNested<A> editOrNewSaslLike(KafkaSASLSpec item) {
        return withNewSaslLike(getSasl() != null ? getSasl(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public KafkaTLSSpec getTls() {
        return this.tls!=null?this.tls.build():null;
    }

    public KafkaTLSSpec buildTls() {
        return this.tls!=null?this.tls.build():null;
    }

    public A withTls(KafkaTLSSpec tls) {
        _visitables.get("tls").remove(this.tls);
        if (tls!=null){ this.tls= new KafkaTLSSpecBuilder(tls); _visitables.get("tls").add(this.tls);} return (A) this;
    }

    public Boolean hasTls() {
        return this.tls != null;
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.TlsNested<A> withNewTls() {
        return new TlsNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.TlsNested<A> withNewTlsLike(KafkaTLSSpec item) {
        return new TlsNestedImpl(item);
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.TlsNested<A> editTls() {
        return withNewTlsLike(getTls());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.TlsNested<A> editOrNewTls() {
        return withNewTlsLike(getTls() != null ? getTls(): new KafkaTLSSpecBuilder().build());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.TlsNested<A> editOrNewTlsLike(KafkaTLSSpec item) {
        return withNewTlsLike(getTls() != null ? getTls(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaNetSpecFluentImpl that = (KafkaNetSpecFluentImpl) o;
        if (sasl != null ? !sasl.equals(that.sasl) :that.sasl != null) return false;
        if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(sasl,  tls,  super.hashCode());
    }

    public class SaslNestedImpl<N> extends KafkaSASLSpecFluentImpl<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.SaslNested<N>> implements io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.SaslNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaSASLSpecBuilder builder;

            SaslNestedImpl(KafkaSASLSpec item) {
                this.builder = new KafkaSASLSpecBuilder(this, item);
                        
            }

            SaslNestedImpl() {
                this.builder = new KafkaSASLSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaNetSpecFluentImpl.this.withSasl(builder.build());
            }

            public N endSasl() {
                return and();
            }
    }


    public class TlsNestedImpl<N> extends KafkaTLSSpecFluentImpl<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.TlsNested<N>> implements io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaTLSSpecBuilder builder;

            TlsNestedImpl(KafkaTLSSpec item) {
                this.builder = new KafkaTLSSpecBuilder(this, item);
                        
            }

            TlsNestedImpl() {
                this.builder = new KafkaTLSSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaNetSpecFluentImpl.this.withTls(builder.build());
            }

            public N endTls() {
                return and();
            }
    }


}
