package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SequenceBuilder extends SequenceFluentImpl<SequenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Sequence,SequenceBuilder> {

    SequenceFluent<?> fluent;
    Boolean validationEnabled;

    public SequenceBuilder() {
        this(true);
    }

    public SequenceBuilder(Boolean validationEnabled) {
        this(new Sequence(), validationEnabled);
    }

    public SequenceBuilder(SequenceFluent<?> fluent) {
        this(fluent, true);
    }

    public SequenceBuilder(SequenceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Sequence(), validationEnabled);
    }

    public SequenceBuilder(SequenceFluent<?> fluent,Sequence instance) {
        this(fluent, instance, true);
    }

    public SequenceBuilder(SequenceFluent<?> fluent,Sequence instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public SequenceBuilder(Sequence instance) {
        this(instance,true);
    }

    public SequenceBuilder(Sequence instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.flows.v1.EditableSequence build() {
        EditableSequence buildable = new EditableSequence(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SequenceBuilder that = (SequenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
