package io.fabric8.knative.flows.v1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class SequenceChannelStatusFluentImpl<A extends SequenceChannelStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SequenceChannelStatusFluent<A> {

    private ObjectReferenceBuilder channel;
    private ConditionBuilder ready;

    public SequenceChannelStatusFluentImpl() {
    }

    public SequenceChannelStatusFluentImpl(SequenceChannelStatus instance) {
        this.withChannel(instance.getChannel()); 
        this.withReady(instance.getReady()); 
    }

    
/**
 * This method has been deprecated, please use method buildChannel instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getChannel() {
        return this.channel!=null?this.channel.build():null;
    }

    public ObjectReference buildChannel() {
        return this.channel!=null?this.channel.build():null;
    }

    public A withChannel(ObjectReference channel) {
        _visitables.get("channel").remove(this.channel);
        if (channel!=null){ this.channel= new ObjectReferenceBuilder(channel); _visitables.get("channel").add(this.channel);} return (A) this;
    }

    public Boolean hasChannel() {
        return this.channel != null;
    }

    public io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ChannelNested<A> withNewChannel() {
        return new ChannelNestedImpl();
    }

    public io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ChannelNested<A> withNewChannelLike(ObjectReference item) {
        return new ChannelNestedImpl(item);
    }

    public io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ChannelNested<A> editChannel() {
        return withNewChannelLike(getChannel());
    }

    public io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ChannelNested<A> editOrNewChannel() {
        return withNewChannelLike(getChannel() != null ? getChannel(): new ObjectReferenceBuilder().build());
    }

    public io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ChannelNested<A> editOrNewChannelLike(ObjectReference item) {
        return withNewChannelLike(getChannel() != null ? getChannel(): item);
    }

    
/**
 * This method has been deprecated, please use method buildReady instead.
 * @return The buildable object.
 */
@Deprecated public Condition getReady() {
        return this.ready!=null?this.ready.build():null;
    }

    public Condition buildReady() {
        return this.ready!=null?this.ready.build():null;
    }

    public A withReady(Condition ready) {
        _visitables.get("ready").remove(this.ready);
        if (ready!=null){ this.ready= new ConditionBuilder(ready); _visitables.get("ready").add(this.ready);} return (A) this;
    }

    public Boolean hasReady() {
        return this.ready != null;
    }

    public io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ReadyNested<A> withNewReady() {
        return new ReadyNestedImpl();
    }

    public io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ReadyNested<A> withNewReadyLike(Condition item) {
        return new ReadyNestedImpl(item);
    }

    public io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ReadyNested<A> editReady() {
        return withNewReadyLike(getReady());
    }

    public io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ReadyNested<A> editOrNewReady() {
        return withNewReadyLike(getReady() != null ? getReady(): new ConditionBuilder().build());
    }

    public io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ReadyNested<A> editOrNewReadyLike(Condition item) {
        return withNewReadyLike(getReady() != null ? getReady(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SequenceChannelStatusFluentImpl that = (SequenceChannelStatusFluentImpl) o;
        if (channel != null ? !channel.equals(that.channel) :that.channel != null) return false;
        if (ready != null ? !ready.equals(that.ready) :that.ready != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(channel,  ready,  super.hashCode());
    }

    public class ChannelNestedImpl<N> extends ObjectReferenceFluentImpl<io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ChannelNested<N>> implements io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ChannelNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectReferenceBuilder builder;

            ChannelNestedImpl(ObjectReference item) {
                this.builder = new ObjectReferenceBuilder(this, item);
                        
            }

            ChannelNestedImpl() {
                this.builder = new ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) SequenceChannelStatusFluentImpl.this.withChannel(builder.build());
            }

            public N endChannel() {
                return and();
            }
    }


    public class ReadyNestedImpl<N> extends ConditionFluentImpl<io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ReadyNested<N>> implements io.fabric8.knative.flows.v1.SequenceChannelStatusFluent.ReadyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConditionBuilder builder;

            ReadyNestedImpl(Condition item) {
                this.builder = new ConditionBuilder(this, item);
                        
            }

            ReadyNestedImpl() {
                this.builder = new ConditionBuilder(this);
                        
            }

            public N and() {
                return (N) SequenceChannelStatusFluentImpl.this.withReady(builder.build());
            }

            public N endReady() {
                return and();
            }
    }


}
