package io.fabric8.knative.flows.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpec;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

public class SequenceSpecFluentImpl<A extends SequenceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SequenceSpecFluent<A> {

    private ChannelTemplateSpecBuilder channelTemplate;
    private DestinationBuilder reply;
    private List<SequenceStepBuilder> steps;

    public SequenceSpecFluentImpl() {
    }

    public SequenceSpecFluentImpl(SequenceSpec instance) {
        this.withChannelTemplate(instance.getChannelTemplate()); 
        this.withReply(instance.getReply()); 
        this.withSteps(instance.getSteps()); 
    }

    
/**
 * This method has been deprecated, please use method buildChannelTemplate instead.
 * @return The buildable object.
 */
@Deprecated public ChannelTemplateSpec getChannelTemplate() {
        return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public ChannelTemplateSpec buildChannelTemplate() {
        return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public A withChannelTemplate(ChannelTemplateSpec channelTemplate) {
        _visitables.get("channelTemplate").remove(this.channelTemplate);
        if (channelTemplate!=null){ this.channelTemplate= new ChannelTemplateSpecBuilder(channelTemplate); _visitables.get("channelTemplate").add(this.channelTemplate);} return (A) this;
    }

    public Boolean hasChannelTemplate() {
        return this.channelTemplate != null;
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<A> withNewChannelTemplate() {
        return new ChannelTemplateNestedImpl();
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<A> withNewChannelTemplateLike(ChannelTemplateSpec item) {
        return new ChannelTemplateNestedImpl(item);
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<A> editChannelTemplate() {
        return withNewChannelTemplateLike(getChannelTemplate());
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplate() {
        return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): new ChannelTemplateSpecBuilder().build());
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplateLike(ChannelTemplateSpec item) {
        return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): item);
    }

    
/**
 * This method has been deprecated, please use method buildReply instead.
 * @return The buildable object.
 */
@Deprecated public Destination getReply() {
        return this.reply!=null?this.reply.build():null;
    }

    public Destination buildReply() {
        return this.reply!=null?this.reply.build():null;
    }

    public A withReply(Destination reply) {
        _visitables.get("reply").remove(this.reply);
        if (reply!=null){ this.reply= new DestinationBuilder(reply); _visitables.get("reply").add(this.reply);} return (A) this;
    }

    public Boolean hasReply() {
        return this.reply != null;
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<A> withNewReply() {
        return new ReplyNestedImpl();
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<A> withNewReplyLike(Destination item) {
        return new ReplyNestedImpl(item);
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<A> editReply() {
        return withNewReplyLike(getReply());
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<A> editOrNewReply() {
        return withNewReplyLike(getReply() != null ? getReply(): new DestinationBuilder().build());
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<A> editOrNewReplyLike(Destination item) {
        return withNewReplyLike(getReply() != null ? getReply(): item);
    }

    public A addToSteps(int index,SequenceStep item) {
        if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
        SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").add(index >= 0 ? index : _visitables.get("steps").size(), builder);this.steps.add(index >= 0 ? index : steps.size(), builder); return (A)this;
    }

    public A setToSteps(int index,SequenceStep item) {
        if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
        SequenceStepBuilder builder = new SequenceStepBuilder(item);
        if (index < 0 || index >= _visitables.get("steps").size()) { _visitables.get("steps").add(builder); } else { _visitables.get("steps").set(index, builder);}
        if (index < 0 || index >= steps.size()) { steps.add(builder); } else { steps.set(index, builder);}
         return (A)this;
    }

    public A addToSteps(SequenceStep... items) {
        if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
        for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
    }

    public A addAllToSteps(Collection<SequenceStep> items) {
        if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
        for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
    }

    public A removeFromSteps(SequenceStep... items) {
        for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
    }

    public A removeAllFromSteps(Collection<SequenceStep> items) {
        for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSteps(Predicate<SequenceStepBuilder> predicate) {
        if (steps == null) return (A) this;
        final Iterator<SequenceStepBuilder> each = steps.iterator();
        final List visitables = _visitables.get("steps");
        while (each.hasNext()) {
          SequenceStepBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSteps instead.
 * @return The buildable object.
 */
@Deprecated public List<SequenceStep> getSteps() {
        return build(steps);
    }

    public List<SequenceStep> buildSteps() {
        return build(steps);
    }

    public SequenceStep buildStep(int index) {
        return this.steps.get(index).build();
    }

    public SequenceStep buildFirstStep() {
        return this.steps.get(0).build();
    }

    public SequenceStep buildLastStep() {
        return this.steps.get(steps.size() - 1).build();
    }

    public SequenceStep buildMatchingStep(Predicate<SequenceStepBuilder> predicate) {
        for (SequenceStepBuilder item: steps) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingStep(Predicate<SequenceStepBuilder> predicate) {
        for (SequenceStepBuilder item: steps) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSteps(List<SequenceStep> steps) {
        if (this.steps != null) { _visitables.get("steps").removeAll(this.steps);}
        if (steps != null) {this.steps = new ArrayList<SequenceStepBuilder>(); for (SequenceStep item : steps){this.addToSteps(item);}} else { this.steps = null;} return (A) this;
    }

    public A withSteps(SequenceStep... steps) {
        if (this.steps != null) {this.steps.clear();}
        if (steps != null) {for (SequenceStep item :steps){ this.addToSteps(item);}} return (A) this;
    }

    public Boolean hasSteps() {
        return steps != null && !steps.isEmpty();
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> addNewStep() {
        return new StepsNestedImpl();
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> addNewStepLike(SequenceStep item) {
        return new StepsNestedImpl(-1, item);
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> setNewStepLike(int index,SequenceStep item) {
        return new StepsNestedImpl(index, item);
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> editStep(int index) {
        if (steps.size() <= index) throw new RuntimeException("Can't edit steps. Index exceeds size.");
        return setNewStepLike(index, buildStep(index));
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> editFirstStep() {
        if (steps.size() == 0) throw new RuntimeException("Can't edit first steps. The list is empty.");
        return setNewStepLike(0, buildStep(0));
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> editLastStep() {
        int index = steps.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last steps. The list is empty.");
        return setNewStepLike(index, buildStep(index));
    }

    public io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<A> editMatchingStep(Predicate<SequenceStepBuilder> predicate) {
        int index = -1;
        for (int i=0;i<steps.size();i++) { 
        if (predicate.test(steps.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching steps. No match found.");
        return setNewStepLike(index, buildStep(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SequenceSpecFluentImpl that = (SequenceSpecFluentImpl) o;
        if (channelTemplate != null ? !channelTemplate.equals(that.channelTemplate) :that.channelTemplate != null) return false;
        if (reply != null ? !reply.equals(that.reply) :that.reply != null) return false;
        if (steps != null ? !steps.equals(that.steps) :that.steps != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(channelTemplate,  reply,  steps,  super.hashCode());
    }

    public class ChannelTemplateNestedImpl<N> extends ChannelTemplateSpecFluentImpl<io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<N>> implements io.fabric8.knative.flows.v1.SequenceSpecFluent.ChannelTemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ChannelTemplateSpecBuilder builder;

            ChannelTemplateNestedImpl(ChannelTemplateSpec item) {
                this.builder = new ChannelTemplateSpecBuilder(this, item);
                        
            }

            ChannelTemplateNestedImpl() {
                this.builder = new ChannelTemplateSpecBuilder(this);
                        
            }

            public N and() {
                return (N) SequenceSpecFluentImpl.this.withChannelTemplate(builder.build());
            }

            public N endChannelTemplate() {
                return and();
            }
    }


    public class ReplyNestedImpl<N> extends DestinationFluentImpl<io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<N>> implements io.fabric8.knative.flows.v1.SequenceSpecFluent.ReplyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DestinationBuilder builder;

            ReplyNestedImpl(Destination item) {
                this.builder = new DestinationBuilder(this, item);
                        
            }

            ReplyNestedImpl() {
                this.builder = new DestinationBuilder(this);
                        
            }

            public N and() {
                return (N) SequenceSpecFluentImpl.this.withReply(builder.build());
            }

            public N endReply() {
                return and();
            }
    }


    public class StepsNestedImpl<N> extends SequenceStepFluentImpl<io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<N>> implements io.fabric8.knative.flows.v1.SequenceSpecFluent.StepsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SequenceStepBuilder builder;
        private final int index;

            StepsNestedImpl(int index,SequenceStep item) {
                this.index = index;
                this.builder = new SequenceStepBuilder(this, item);
                        
            }

            StepsNestedImpl() {
                this.index = -1;
                this.builder = new SequenceStepBuilder(this);
                        
            }

            public N and() {
                return (N) SequenceSpecFluentImpl.this.setToSteps(index,builder.build());
            }

            public N endStep() {
                return and();
            }
    }


}
