package io.fabric8.knative.flows.v1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class SequenceSubscriptionStatusFluentImpl<A extends SequenceSubscriptionStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SequenceSubscriptionStatusFluent<A> {

    private ConditionBuilder ready;
    private ObjectReferenceBuilder subscription;

    public SequenceSubscriptionStatusFluentImpl() {
    }

    public SequenceSubscriptionStatusFluentImpl(SequenceSubscriptionStatus instance) {
        this.withReady(instance.getReady()); 
        this.withSubscription(instance.getSubscription()); 
    }

    
/**
 * This method has been deprecated, please use method buildReady instead.
 * @return The buildable object.
 */
@Deprecated public Condition getReady() {
        return this.ready!=null?this.ready.build():null;
    }

    public Condition buildReady() {
        return this.ready!=null?this.ready.build():null;
    }

    public A withReady(Condition ready) {
        _visitables.get("ready").remove(this.ready);
        if (ready!=null){ this.ready= new ConditionBuilder(ready); _visitables.get("ready").add(this.ready);} return (A) this;
    }

    public Boolean hasReady() {
        return this.ready != null;
    }

    public io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.ReadyNested<A> withNewReady() {
        return new ReadyNestedImpl();
    }

    public io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.ReadyNested<A> withNewReadyLike(Condition item) {
        return new ReadyNestedImpl(item);
    }

    public io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.ReadyNested<A> editReady() {
        return withNewReadyLike(getReady());
    }

    public io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.ReadyNested<A> editOrNewReady() {
        return withNewReadyLike(getReady() != null ? getReady(): new ConditionBuilder().build());
    }

    public io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.ReadyNested<A> editOrNewReadyLike(Condition item) {
        return withNewReadyLike(getReady() != null ? getReady(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSubscription instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getSubscription() {
        return this.subscription!=null?this.subscription.build():null;
    }

    public ObjectReference buildSubscription() {
        return this.subscription!=null?this.subscription.build():null;
    }

    public A withSubscription(ObjectReference subscription) {
        _visitables.get("subscription").remove(this.subscription);
        if (subscription!=null){ this.subscription= new ObjectReferenceBuilder(subscription); _visitables.get("subscription").add(this.subscription);} return (A) this;
    }

    public Boolean hasSubscription() {
        return this.subscription != null;
    }

    public io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.SubscriptionNested<A> withNewSubscription() {
        return new SubscriptionNestedImpl();
    }

    public io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.SubscriptionNested<A> withNewSubscriptionLike(ObjectReference item) {
        return new SubscriptionNestedImpl(item);
    }

    public io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.SubscriptionNested<A> editSubscription() {
        return withNewSubscriptionLike(getSubscription());
    }

    public io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.SubscriptionNested<A> editOrNewSubscription() {
        return withNewSubscriptionLike(getSubscription() != null ? getSubscription(): new ObjectReferenceBuilder().build());
    }

    public io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.SubscriptionNested<A> editOrNewSubscriptionLike(ObjectReference item) {
        return withNewSubscriptionLike(getSubscription() != null ? getSubscription(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SequenceSubscriptionStatusFluentImpl that = (SequenceSubscriptionStatusFluentImpl) o;
        if (ready != null ? !ready.equals(that.ready) :that.ready != null) return false;
        if (subscription != null ? !subscription.equals(that.subscription) :that.subscription != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ready,  subscription,  super.hashCode());
    }

    public class ReadyNestedImpl<N> extends ConditionFluentImpl<io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.ReadyNested<N>> implements io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.ReadyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConditionBuilder builder;

            ReadyNestedImpl(Condition item) {
                this.builder = new ConditionBuilder(this, item);
                        
            }

            ReadyNestedImpl() {
                this.builder = new ConditionBuilder(this);
                        
            }

            public N and() {
                return (N) SequenceSubscriptionStatusFluentImpl.this.withReady(builder.build());
            }

            public N endReady() {
                return and();
            }
    }


    public class SubscriptionNestedImpl<N> extends ObjectReferenceFluentImpl<io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.SubscriptionNested<N>> implements io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent.SubscriptionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectReferenceBuilder builder;

            SubscriptionNestedImpl(ObjectReference item) {
                this.builder = new ObjectReferenceBuilder(this, item);
                        
            }

            SubscriptionNestedImpl() {
                this.builder = new ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) SequenceSubscriptionStatusFluentImpl.this.withSubscription(builder.build());
            }

            public N endSubscription() {
                return and();
            }
    }


}
