package io.fabric8.knative.internal.eventing.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DeliverySpecBuilder extends DeliverySpecFluentImpl<DeliverySpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<DeliverySpec,DeliverySpecBuilder> {

    DeliverySpecFluent<?> fluent;
    Boolean validationEnabled;

    public DeliverySpecBuilder() {
        this(true);
    }

    public DeliverySpecBuilder(Boolean validationEnabled) {
        this(new DeliverySpec(), validationEnabled);
    }

    public DeliverySpecBuilder(DeliverySpecFluent<?> fluent) {
        this(fluent, true);
    }

    public DeliverySpecBuilder(DeliverySpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DeliverySpec(), validationEnabled);
    }

    public DeliverySpecBuilder(DeliverySpecFluent<?> fluent,DeliverySpec instance) {
        this(fluent, instance, true);
    }

    public DeliverySpecBuilder(DeliverySpecFluent<?> fluent,DeliverySpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBackoffDelay(instance.getBackoffDelay()); 
        fluent.withBackoffPolicy(instance.getBackoffPolicy()); 
        fluent.withDeadLetterSink(instance.getDeadLetterSink()); 
        fluent.withRetry(instance.getRetry()); 
        this.validationEnabled = validationEnabled; 
    }

    public DeliverySpecBuilder(DeliverySpec instance) {
        this(instance,true);
    }

    public DeliverySpecBuilder(DeliverySpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBackoffDelay(instance.getBackoffDelay()); 
        this.withBackoffPolicy(instance.getBackoffPolicy()); 
        this.withDeadLetterSink(instance.getDeadLetterSink()); 
        this.withRetry(instance.getRetry()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.EditableDeliverySpec build() {
        EditableDeliverySpec buildable = new EditableDeliverySpec(fluent.getBackoffDelay(),fluent.getBackoffPolicy(),fluent.getDeadLetterSink(),fluent.getRetry());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DeliverySpecBuilder that = (DeliverySpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
